/*
 * S.F.S. v. 0.5alpha-linux
 *
 * lsecure.h contains some defines and constants to se-up lsecure.c
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 * This code derives from: 
 *
 */

/* Standard limits */
#define MAX_PATHLEN      1024

/* Default secure flags */
#define SECURE          7
#define UNSECURE        0

/* Error codes */
#define ERR_USE         -1                /* Command line error */

#define RPC_FAIL        -1                /* RPC-Call error */

#define LSEC_OK          1                /* Lsecure function ok */
#define ERR_FILE        -2                /* File not found */
#define ERR_IOCTL       -1                /* Ioctl failed */
#define ERR_ACCESS      -3                /* File access denied */
#define ERR_STICK	-4		  /* Entry not found in mountd-table */
#define ERR_SFSREG      -5                /* User does not registered */


/* Function to build the absolute path of file */
char *makepath(char *fname)
{
  char *absfname;                                /* Absolute pathname        */

  if(*fname=='/') return(fname);

  absfname=malloc(MAX_PATHLEN);
  getcwd(absfname, MAX_PATHLEN);
  if(absfname[strlen(absfname)-1]!="/")
    strcat(absfname, "/");
  strcat(absfname, fname);
  return(absfname);
}
