/*
 * S.F.S. v. 0.5alpha-linux
 *
 * sfs_server.c: sfslogin server side ....
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "uid.h"

#include <syslog.h>

#ifndef KEYSIZE
#define KEYSIZE		8
#endif

#ifndef COMMANDSIZE
#define COMMANDSIZE	3
#endif

#ifndef SFSDPORT
#define SFSDPORT	9000
#endif

extern void fh_flushuid(int);
typedef struct sockaddr saddr;
typedef struct sockaddr_in saddrin;

#define saddrsize sizeof (saddr)
#define saddrinsize sizeof (saddrin)

int keysock;
saddrin *keysocket;

int initkeysock (void)
{

#ifdef BOF
  syslog (LOG_DAEMON, "initkeysock");
#endif

  keysocket=(struct sockaddr_in *)malloc(sizeof(struct sockaddr_in));
  keysocket->sin_family=AF_INET;
  keysocket->sin_port=htons(SFSDPORT);
  keysocket->sin_addr.s_addr=htonl(INADDR_ANY);
  
  keysock=socket(AF_INET, SOCK_STREAM, 0);
  
  if (bind(keysock, (saddr*)keysocket, saddrsize)==-1)
    return -1;
  
  if (fcntl(keysock, F_SETOWN, getpgrp())==-1)
    {
      perror ("fcntl");
      exit(1);
    }
  
#ifdef __linux__
  if (fcntl(keysock, F_SETFL, FASYNC | O_NONBLOCK)<0)
    {
      perror ("fcntl");
      exit(1);
    }
#endif

  listen(keysock, 5);
  return 0;
}	

void receivekey (int sign) /* handler */
{
	int newsock;
	int len;
	char key[KEYSIZE];
	uid_t uid;
	char command[COMMANDSIZE];

#ifdef BOF
	syslog (LOG_DAEMON, "receivekey");
#endif

	newsock=accept(keysock, (saddr*)keysocket, &len);

	recv(newsock, command, COMMANDSIZE+1, 0);

#ifdef BOF
	syslog (LOG_DAEMON, command);
#endif

	recv(newsock, &uid, sizeof(uid_t), 0);

	if (strncmp(command, "add", COMMANDSIZE)==0)
	{
		recv (newsock, key, KEYSIZE, 0);
		set_fskey (uid, key);
		fh_flushuid(uid);
	}
	else
	if (strncmp(command, "rem", COMMANDSIZE)==0)
	{
		recv (newsock, key, KEYSIZE, 0);
		if (strncmp (key, fskey (uid), KEYSIZE)==0){
			del_fskey (uid);
			fh_flushuid(uid);
		}
#ifdef BOF
		else
			syslog (LOG_DAEMON, "Unauthorized attempt to remove a key!");
#endif
	}

	close(newsock);

#ifdef __linux__
	signal (SIGIO, receivekey);
#endif
}


