/*
 * T.C.F.S. v. 0.5alpha-linux
 *
 * tcfslogout    disable the user to use the tcfs-filesystem
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "defines.h"
#include "tcfscode.h"

#ifndef SECUDEDES
#include "d3des.h"
#endif

typedef struct sockaddr saddr;
typedef struct sockaddr_in saddrin;

#define saddrsize sizeof (saddr)
#define saddrinsize sizeof (saddrin)

extern char *getsfskey (char *);

void deletekey (char *sfskey)
{
        saddrin *serversock;
        int sock;
        uid_t uid;
        char *command;

        command=(char*)calloc(4,sizeof(char));
        serversock=(saddrin*)malloc(saddrinsize);

        serversock->sin_family=AF_INET;
        serversock->sin_port=htons(SFSDPORT);
        serversock->sin_addr.s_addr=htonl(INADDR_ANY);

        sock=socket(AF_INET, SOCK_STREAM, 0);

        if (connect(sock, (saddr*) serversock, saddrsize)==-1)
        {
                fprintf (stderr, "Cannot connect to tcfsd\n");
                exit (1);
        }

        strcpy (command, "rem");
        *(command+4)='\0';

        if (send (sock, command, strlen(command)+1, MSG_OOB)<0)
        {
                perror ("send");
                exit(1);
        }

        uid=getuid();
        if (send (sock, &uid, sizeof(uid_t), 0)<0)
        {
                perror ("send");
                exit(1);
        }
	
	if (send (sock, sfskey, KEYSIZE, 0)<0)
	{
		perror ("send");
		exit (1);
	}

	close (sock);
	free (serversock);
}

void main (void)
{
	int len;
	char pass[128];
	char *sfskey;
	struct passwd *passentry;

	strcpy (pass, getpass("Please enter your password:"));
	
	if ((passentry=getpwuid (getuid()))==NULL)
	{
		fprintf (stderr, "Who are you??\n");
		exit (1);
	}

	if (strcmp (crypt (pass, passentry->pw_passwd), passentry->pw_passwd)!=0)
	{
		fprintf (stderr, "Illegal password!\n");
		exit (1);
	}
	
	if ((sfskey=getsfskey (getlogin()))==NULL)
	{
		fprintf (stderr, "You are not allowed to use tcfsd.\n");
		exit (1);
	}

	sfskey=sfsdecode (sfskey, &len);
	
	if (strlen (pass)<8)
		strncat (pass, pass, strlen(pass));

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
	setkey_ (pass);
	dedes (sfskey);
#else
	deskey (pass, DE1);
	desd3 (sfskey, sfskey);
#endif
	deletekey(sfskey);
	printf ("Ok.\n");
}
