/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * fstab.h      handle the fstab
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#ifndef _FSTAB_H
#include <stdio.h>
#include <mntent.h>

#define _PATH_FSTAB	"/etc/fstab"

/* Translate fsent(3) stuff into mntent(3) stuff.
   In general this won't work, but it's good enough here.  */
#define fstab mntent
#define fs_type mnt_type
#define fs_spec mnt_fsname
#define FSTAB_SW MNTTYPE_SWAP

struct fstab *getfsent (void);
struct fstab *getfsspec (const char *spec);
struct fstab *getfsfile (const char *file);
int setfsent (void);
void endfsent (void);

#endif /* _FSTAB_H */
