/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * tcfs.h: some common definitions
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#ifndef NINSTANCES
#define NINSTANCES 64
#endif

#define HSIZE 1024
#define HMASK 0x3ff	/* change these together, please */

typedef struct mtable {
  char local_dir[NFS_MAXPATHLEN+1];   /* localhost exported dir on final user sideview */
  char dummy_dir[NFS_MAXPATHLEN+1];  /* dummy dir for mounting purpose */
  char remote_dir[NFS_MAXPATHLEN+1];  /* remote dir on server...imported using NFS */
  char work_dir[NFS_MAXPATHLEN+1];    /* local working dir on final user sideview */
  struct mtable * next;
} mtable;

extern mtable * first;
extern int SFSerrno;
extern int errno;
extern int cursecs;

extern char zerovect[];

#define SFS_READ O_RDONLY
#define SFS_WRITE (O_RDWR)
#define IS_CRYPTED(attr)  (attr==7?1:0)

extern char *admerrs[];
char *admmsg();

extern nfstime roottime;

#ifdef hpux
#define seteuid(x) setresuid(-1,x,-1)
#define setegid(x) setresgid(-1,x,-1)
#endif

#ifdef AIX320EUIDBUG
/* AIX 3.2.0 uses ruid for file ownership on creat even though the docs 
 *  say otherwise !!
 * note that we can still switch back to root. 
 * I bet this is fixed in later AIX releases, in which case this whole 
 *  ifdef can be done away with
 */
#include <sys/id.h>
#include <sys/types.h>
#define become(x) ((x)==NULL?(setuidx(ID_EFFECTIVE | ID_REAL,0)||setgidx(ID_EFFECTIVE|ID_REAL,0)) :\
           (setgidx(ID_EFFECTIVE|ID_REAL,rgid(x)) || setuidx(ID_EFFECTIVE|ID_REAL, ruid(x))))
#else
#define become(x) ((x)==NULL?(seteuid(0)||setegid(0)) :\
		   (setegid(rgid(x)) || seteuid(ruid(x))))
#endif
#define keyof(f) (&((f)->ins->key))
#define vectof(f) ((f)->vect)

#ifdef irix
#define d_fileno d_ino
#endif

#ifdef SOLARIS2X
#define d_fileno d_ino
#define bzero(b, l) 		memset(b, 0, l)
#define bcopy(s, d, l)		memcpy(d, s, l)
#define index(s, c)		strchr(s, c)
#define bcmp(s, d, l)		(memcmp(s, d, l)? 1 : 0)
#endif

#ifdef BSD44
/*
#define d_off d_reclen
#define d_fileno d_ino
*/
#endif
#include<stdlib.h>





























































