/*
 * T.C.F.S. v. 1.0beta-linux
 *
 * sfscrypt.c:  Crypt and DeCrypt Functions...
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

#include <unistd.h>
#include <string.h>
#include "uid.h"
#include <syslog.h>

#ifndef SECUDEDES
#include "d3des.h"
#endif

#include "defines.h"

#define DESBLOCK	8
#define BLOCKSIZE	1024

void sfs_crypt (char *block, int size, long offset, uid_t uid)
{
	unsigned int i=0;
	unsigned miniblocks;
	char *key;

	if ((key=fskey(uid))==NULL)
		return -1;
	
#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
#endif

	/* Set key */
#ifdef SECUDEDES
	setkey_ (key);
#else
	deskey (key, EN0);
#endif

	miniblocks=size/DESBLOCK;

	/* Go to encrypt all miniblocks */
	while (i<miniblocks)
	{

#ifdef SECUDEDES
		endes (block+DESBLOCK*i);
#else
		desd3 (block+DESBLOCK*i, block+DESBLOCK*i);
#endif

		i++;
	}
		
#ifdef SECUDEDES
	desdone ();
#endif
}

void sfs_decrypt (char *block, int size, long offset, uid_t uid)
{
	unsigned int i=0;
	unsigned int miniblocks;
	char *key;

	if ((key=fskey(uid))==NULL)
		return -1;

#ifdef SECUDEDES
	desinit (DESMETHOD, D3DES);
#endif

	/* Set key */
#ifdef SECUDEDES
	setkey_ (key);
#else
	deskey (key, DE1);
#endif

	miniblocks=size/DESBLOCK;

	/* Go to decrypt all miniblocks */
	while (i<miniblocks)
	{

#ifdef SECUDEDES
		dedes (block+DESBLOCK*i);
#else
		desd3 (block+DESBLOCK*i, block+DESBLOCK*i);
#endif

		i++;
	}

#ifdef SECUDEDES
	desdone ();
#endif
}

/*
int sfs_crypt (char *block, int size, long offset, uid_t uid)
{
	int i=0;
	char *key;
	
	if ((key=fskey(uid))==NULL)
		return -1;

	while ((i+BLOCKSIZE)<=size)
	{
		sfs_crypt_1k (block+i, BLOCKSIZE, i+offset, key);
		i+=BLOCKSIZE;
	};

	if ((size-i)>0)
		sfs_crypt_1k (block+i, size-i, i+offset, key);

	return 0;
}

int sfs_decrypt (char *block, int size, long offset, uid_t uid)
{
	int i=0;
	char *key;

	if ((key=fskey(uid))==NULL)
		return -1;

	while ((i+BLOCKSIZE)<=size)
	{
		sfs_decrypt_1k (block+i, BLOCKSIZE, i+offset, key);
		i+=BLOCKSIZE;
	};

	if ((size-i)>0)
		sfs_decrypt_1k (block+i, size-i, i+offset, key);

	return 0;
}
*/
