/*
 * T.C.F.S. 2.0 Alpha 1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */



/*
 *  smbmount.c
 *
 *  Copyright (C) 1995 by Paal-Kr. Engstad and Volker Lendecke
 *
 *  Modified 1996 by Marc A. Pelletier <marc@softguard.com> to merge with mount(8)
 *
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>  /* generates a warning here */
/* extern pid_t waitpid(pid_t, int *, int); */
#include <sys/errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <mntent.h>

#include <linux/fs.h>
#include <linux/smb.h>
#include <linux/smb_mount.h>

#include "sundries.h"
#include "mount.h"


static void
str_upper(char *name)
{
	while (*name)  {
		*name = toupper(*name);
		name = name + 1;
	}
}


static int
extract_service(const char *service, char **server, char **share, char **root,
                char **user)
{
        char service_copy[strlen(service)+1];
        char *complete_service;

        char *share_start;
        char *root_start;
        char *user_start;

        static char s_server[64];
        static char s_share [64];
        static char s_root  [64];
        static char s_user  [64];

        strcpy(service_copy, service);
        complete_service = service_copy;

        if (strlen(complete_service) < 4) {
        	errno = ENODEV;
                return -1;
        }

        if (complete_service[0] != '/') {
        	errno = ENODEV;
                return -1;
        }

        while (complete_service[0] == '/') complete_service += 1;

        share_start = strchr(complete_service, '/');

        if (share_start == NULL) {
        	errno = ENODEV;
                return -1;
        }

        share_start[0] = '\0';
        share_start += 1;

        root_start = strchr(share_start, '/');

        if (root_start != NULL) {
                root_start[0] = '\0';
                root_start += 1;
        }

        if (   (strlen(complete_service) > 63)
            || (strlen(share_start) > 63)) {
        	errno = ENODEV;
                return -1;
        }

        if (root_start != NULL) {

                int i;

                if (strlen(root_start) > 62) {
        		errno = ENODEV;
                        return -1;
                }

                s_root[0] = '/';
                strcpy(s_root+1, root_start);

                for (i = 0; s_root[i] != '\0'; i++) {
                        if (s_root[i] == '/') {
                                s_root[i] = '\\';
                        }
                }

                /* i == strlen(s_root) */
                if (s_root[i-1] == '\\') {
                        s_root[i-1] = '\0';
                }
        } else {
                s_root[0] = '\0';
        }

        user_start = strchr(share_start, '%');

        if (user_start != NULL) {
                user_start[0] = '\0';
                user_start += 1;
                strcpy(s_user, user_start);
        } else {
                s_user[0] = '\0';
        }

        strcpy(s_server, complete_service);
        strcpy(s_share,  share_start);

        *server = s_server;
        *share  = s_share;
        *root   = s_root;
        *user   = s_user;
        return 0;
}


/* Check whether user is allowed to mount on the specified mount point */
static int
mount_ok(struct stat *st)
{
        if (!S_ISDIR(st->st_mode))
        {
                errno = ENOTDIR;
                return -1;
        }
	
        if (   (getuid() != 0)
            && (   (getuid() != st->st_uid)
                || ((st->st_mode & S_IRWXU) != S_IRWXU)))
        {
                errno = EPERM;
                return -1;
        }

        return 0;
}



int 
mount_smbfs(const char* service, const char* mount_point,
		unsigned short port, const char* server, const char* client,
		uid_t uid, gid_t gid, int fmode, int dmode, int upcase, const char* password)
{
        struct smb_mount_data data;
        struct stat	st;

        int		um;
	unsigned int	flags;
	char		myhostname[MAXHOSTNAMELEN + 1];

	char*		nb_server;
	char*		nb_share;
	char*		nb_root;
	char*		nb_user;

	char*		cp;

	struct hostent	*h;

	memset(&data, 0, sizeof(struct smb_mount_data));

	memset(myhostname, '\0', MAXHOSTNAMELEN+1);
	gethostname(myhostname, MAXHOSTNAMELEN);

        if (extract_service(service, &nb_server, &nb_share, &nb_root, &nb_user) != 0)
                return -1;

        if (stat(mount_point, &st) == -1)
        	return -1;

        if (mount_ok(&st) != 0)
        	return -1;

        if ((h = gethostbyname(nb_server)) == NULL)
        {
		errno = ENOENT;
		return -1;
	}

	if(!port)
		port = SMB_PORT;

	data.addr.sin_family      = AF_INET;
        data.addr.sin_addr.s_addr = ((struct in_addr *)(h->h_addr))->s_addr;
	data.addr.sin_port        = htons(port);
	
	data.fd = socket(AF_INET, SOCK_STREAM, 0);
	if (data.fd == -1)
                return -1;
	
	data.version = SMB_MOUNT_VERSION;

        /* getuid() gives us the real uid, who may umount the fs */
        data.mounted_uid = getuid();

        strncpy(data.service, nb_share, 63);
        str_upper(data.service);

        strncpy(data.root_path, nb_root, 63);

        if(nb_user)
          strncpy(data.username, nb_user, 63);

        if (!data.username[0] && getenv("USER"))
                strncpy(data.username, getenv("USER"), 63);

        if (data.username[0] == 0 && getenv("LOGNAME"))
                strncpy(data.username,getenv("LOGNAME"), 63);

        str_upper(data.username);

        data.max_xmit = 4070;   /* allocate at most one page in kernel */
        data.uid = (uid==0)? getuid(): uid;
        data.gid = (gid==0)? getgid(): gid;
        um = umask(0);
        umask(um);
        data.file_mode = fmode? fmode: ((S_IRWXU|S_IRWXG|S_IRWXO) & ~um);
        data.dir_mode  = dmode? dmode: 0;

        if (data.dir_mode == 0)
        {
                data.dir_mode = data.file_mode;
                if ((data.dir_mode & S_IRUSR) != 0)
                        data.dir_mode |= S_IXUSR;
                if ((data.dir_mode & S_IRGRP) != 0)
                        data.dir_mode |= S_IXGRP;
                if ((data.dir_mode & S_IROTH) != 0)
                        data.dir_mode |= S_IXOTH;
        }

        if (!password)
                strcpy(data.password, getpass("Password: "));
        else
        	strcpy(data.password, password);

        if (upcase)
                str_upper(data.password);

        if(server)
          strcpy(data.server_name, server);
        else
          strcpy(data.server_name, nb_server);
        str_upper(data.server_name);
        
        if(client)
          strncpy(data.client_name, client, 16);
        else if((cp = strchr(myhostname, '.')) && (cp-myhostname)<17)
          strncpy(data.client_name, myhostname, (cp-myhostname));
        else
          strncpy(data.client_name, myhostname, 16);
        str_upper(data.client_name);
   
	flags = MS_MGC_VAL;

	if (mount(NULL, mount_point, "smbfs", flags, (char *)&data) < 0)
	{
        	flags = errno;
	        close(data.fd);
	        errno = flags;
	        if(errno = EINVAL)
	          errno = EACCES;	/* Most likely cause is bad password.  guess it so.  */
		return -1;
	}

        close(data.fd);

	return 0;
}	


int smbfsmount(const char *spec, const char *node, int *flags,
	     char **extra_opts, char **mount_opts);
int smbfsmount(const char *spec, const char *node, int *flags,
	     char **extra_opts, char **mount_opts)
    {
	char*		opt;
	char*		opteq;
	char		opttxt[1024];
	int		val;
	int		i;

	unsigned short	port = 0;
	char*		server = 0;
	char*		client = 0;
	uid_t		uid = 0;
	gid_t		gid = 0;
	int		fmode = 0;
	int		dmode = 0;
	int		upcase = 0;
	char*		password = 0;

	for (opt = strtok(*extra_opts, ","); opt; opt = strtok(NULL, ","))
	    {
		if ((opteq = strchr(opt, '=')))
		    {
		        i = strcspn(opteq+1, " \t\n\r,");
		        strncpy(opttxt, opteq+1, i);
		        opttxt[i] = 0;
			val = atoi(opttxt);

			*opteq = '\0';
			if(!strcmp(opt, "port"))
			    port = val;
			else if(!strcmp(opt, "server"))
			    server = strdup(opttxt);
			else if(!strcmp(opt, "client"))
			    client = strdup(opttxt);
			else if(!strcmp(opt, "password"))
			    password = strdup(opttxt);
			else if(!strcmp(opt, "fmode"))
			    fmode = strtol(opttxt, 0, 8);
			else if(!strcmp(opt, "dmode"))
			    dmode = strtol(opttxt, 0, 8);
			else if(!strcmp(opt, "uid") || !strcmp(opt, "user"))
			  {
			    if(isdigit(opteq[1]))
			    	uid = val;
			    else
			      {
			        struct passwd*	pw;

			        pw = getpwnam(opttxt);

			        if(pw)
			          {
			            uid = pw->pw_uid;
			            free(pw);
			          }
			        else
			          printf("unknown user for smbfs mount: %s\n", opttxt);
			      }
			  }
			else if(!strcmp(opt, "gid") || !strcmp(opt, "group"))
			  {
			    if(isdigit(opteq[1]))
			    	gid = val;
			    else
			      {
			        struct group*	gr;

			        gr = getgrnam(opttxt);

			        if(gr)
			          {
			            gid = gr->gr_gid;
			            free(gr);
			          }
			        else
			          printf("unknown group for smbfs mount: %s\n", opttxt);
			      }
			  }
			else
			  {
				printf("unknown smbfs mount parameter: %s=%s\n", opt, opttxt);
				return 1;
			  }
		    }
		else
		    {
			val = 1;
			if (!strncmp(opt, "no", 2))
			    {
				val = 0;
				opt += 2;
			    }
			else if(*opt == '!')
			    {
			    	val = 0;
			    	opt++;
			    }
			if (!strcmp(opt, "upcase")) 
			    upcase = val;
			else if(!strcmp(opt, "password"))
			    {
			        if(!val)
			            password = "";
			    }
			else
			    {
				printf("unknown smbfs mount option: %s%s\n", val ? "" : "no", opt);
				return 1;
			    }
		    }
	    }

	return mount_smbfs(spec, node, port, server, client, uid, gid, fmode, dmode, upcase, password);
    }


