/*
 * T.C.F.S. Utils 2.0 $Revision: 1.9 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/include/RCS/tcfslib.h,v $
 *        $State: Exp $
 *
 *     $Revision: 1.9 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 15:02:47 $
 *       $Locker:  $
 */              
/* -+-_== */ 

#include "tcfsdefines.h"
#include "tcfspwdb.h"

/*
 * Function prototyping
 */

int tcfspwdbr_new (tcfspwdb **p);
int tcfspwdbr_edit (tcfspwdb *p, int i, ...);
int tcfspwdbr_read (tcfspwdb *p, int i, ...);
int tcfspwdbr_dispose (tcfspwdb *p);
int tcfs_chgkey (char *u, char *o, char *p);
int tcfs_decrypt_key (char *u, char *pwd, char *t, char **tk);
int tcfs_encrypt_key (char *u, char *pw, char *key, char **ek);
int tcfs_callfunction (int function, char *arg, char *filesystem, char *filename);
int tcfs_enable (char *u, char *tcfskey);
int tcfs_enable_default (char *u, char *p);
int tcfs_disable (char *u, int flags);
int tcfs_permanent (char *u, int flags);
int tcfs_getcount (char *u);
int tcfs_getpermanent (char *u);

char *tcfs_decode (char *t, int *l);
char *tcfs_encode (char *t, int l);
char *gentcfskey (void);

#ifdef GDBM_SUPPORT
tcfspwdb *tcfs_gdbm_getpwnam (char *user, tcfspwdb *dest);
int tcfs_gdbm_putpwnam (char *user, tcfspwdb *src, int flags);
#define tcfs_getpwnam	tcfs_gdbm_getpwnam
#define tcfs_putpwnam	tcfs_gdbm_putpwnam
#else
tcfspwdb *tcfs_text_getpwnam (char *u, tcfspwdb *dest);
int tcfs_textdb_putpwnam (tcfspwdb *f, int flags);
#define tcfs_getpwnam	tcfs_text_getpwnam
#define tcfs_putpwnam	tcfs_textdb_putpwnam
#endif
