/*
 * T.C.F.S. 2.0.1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */
#ifndef _LINUX_TCFS_FS_H
#define _LINUX_TCFS_FS_H

/*
 *  linux/include/linux/tcfs_fs.h
 *
 *  Copyright (C) 1992  Rick Sladkey
 *
 *  OS-specific tcfs filesystem definitions and declarations
 */

#include <linux/tcfs.h>
#include <linux/kdes.h>
#include <linux/tcfs_in.h>
#include <linux/tcfs_mount.h>
#include <asm/ioctl.h>

/* Here we define IOCTL functions for TCFS ... since we use extended
 * attributes to manage cryptgraphed files, we define GETFLAGS and
 * SETFLAGS as they are in the ext2 fs ... so  you can use ext2 utils
 * to manage extended attributes via TCFS */


#define TCFS_IOC_GETFLAGS	_IOR('f', 1, long)
#define TCFS_IOC_SETFLAGS	_IOW('f', 2, long) 

#define TCFS_IOC_LOGIN		_IOW('l', 1, struct login)    
#define TCFS_IOC_LOGOUT		_IOW('l', 2, unsigned int)
#define TCFS_IOC_SETFIX         _IO('l', 3) 
#define TCFS_IOC_DELFIX		_IO('l', 4)
#define TCFS_IOC_GETFIX  	_IOR('l', 5, unsigned char)
#define TCFS_IOC_GETCOUNT	_IOR('l', 6, unsigned int)
#define TCFS_IOC_FULLOUT	_IOW('l', 7, unsigned int)

#define TCFS_IOC_GETVERSION	_IOR('v', 1, long)
#define TCFS_IOC_SETVERSION	_IOW('v', 2, long)

/*
 * The readdir cache size controls how many directory entries are cached.
 * Its size is limited by the number of tcfs_entry structures that can fit
 * in one page, currently, the limit is 256 when using 4KB pages.
 */

#define TCFS_READDIR_CACHE_SIZE		64

#define TCFS_MAX_FILE_IO_BUFFER_SIZE	16384
#define TCFS_DEF_FILE_IO_BUFFER_SIZE	1024

/*
 * The upper limit on timeouts for the exponential backoff algorithm.
 */

#define TCFS_MAX_TCRPC_TIMEOUT		(6*HZ)

/*
 * Size of the lookup cache in units of number of entries cached.
 * It is better not to make this too large although the optimum
 * depends on a usage and environment.
 */

#define TCFS_LOOKUP_CACHE_SIZE		64

#define TCFS_SUPER_MAGIC			0x6969

#define TCFS_SERVER(inode)		(&(inode)->i_sb->u.tcfs_sb.s_server)
#define TCFS_FH(inode)			(&(inode)->u.tcfs_i.fhandle)
#define TCFS_RENAMED_DIR(inode)		((inode)->u.tcfs_i.silly_rename_dir)
#define TCFS_READTIME(inode)		((inode)->u.tcfs_i.read_cache_jiffies)
#define TCFS_OLDMTIME(inode)		((inode)->u.tcfs_i.read_cache_mtime)

#define TCFS_ATTRTIMEO(inode)		((inode)->u.tcfs_i.attrtimeo)

#define TCFS_MINATTRTIMEO(inode)		(S_ISREG((inode)->i_mode)?	\
						TCFS_SERVER(inode)->acregmin : \
						TCFS_SERVER(inode)->acdirmin)
#define TCFS_CACHEINV(inode) \
do { \
	TCFS_READTIME(inode) = jiffies - 1000000; \
	TCFS_OLDMTIME(inode) = 0; \
} while (0)

struct login
{
	int len;
	uid_t uid;
	char deskey[64];
};

#ifdef __KERNEL__

struct hash_entry {
	unsigned int uid;
	char deskey[64];
	/* BUG    we should use a define */
	unsigned int count;
	unsigned char permanent;
	void *ks;
	struct hash_entry * next;
};
#define HASH_SIZE 10

/* linux/fs/tcfs/ioctl.c */
extern int tcfs_ioctl (struct inode *, struct file *, unsigned int,unsigned long);
/* linux/fs/tcfs/proc.c */
extern int tcfs_proc_geteattr(struct tcfs_server *server, char *filename,
			    unsigned int *cflag);
extern int tcfs_proc_seteattr(struct inode* inode,struct tcfs_server *server, char *filename, unsigned int cflag,struct file *filp);

extern int tcfs_proc_getattr(struct tcfs_server *server, struct tcfs_fh *fhandle,
			    struct tcfs_fattr *fattr);
extern int tcfs_proc_setattr(struct tcfs_server *server, struct tcfs_fh *fhandle,
			    struct tcfs_sattr *sattr, struct tcfs_fattr *fattr);
extern int tcfs_proc_lookup(struct tcfs_server *server, struct tcfs_fh *dir,
			   const char *name, struct tcfs_fh *fhandle,
			   struct tcfs_fattr *fattr);
extern int tcfs_proc_readlink(struct tcfs_server *server, struct tcfs_fh *fhandle,
			int **p0, char **string, unsigned int *len,
			unsigned int maxlen);
extern int tcfs_proc_read(struct tcfs_server *server, struct tcfs_fh *fhandle,
			 int offset, int count, char *data,
			 struct tcfs_fattr *fattr);
extern int tcfs_proc_write(struct inode * inode, int offset,
			  int count, const char *data, struct tcfs_fattr *fattr);
extern int tcfs_proc_create(struct tcfs_server *server, struct tcfs_fh *dir,
			   const char *name, struct tcfs_sattr *sattr,
			   struct tcfs_fh *fhandle, struct tcfs_fattr *fattr);
extern int tcfs_proc_remove(struct tcfs_server *server, struct tcfs_fh *dir,
			   const char *name);
extern int tcfs_proc_rename(struct tcfs_server *server,
			   struct tcfs_fh *old_dir, const char *old_name,
			   struct tcfs_fh *new_dir, const char *new_name,
			   int must_be_dir);
extern int tcfs_proc_link(struct tcfs_server *server, struct tcfs_fh *fhandle,
			 struct tcfs_fh *dir, const char *name);
extern int tcfs_proc_symlink(struct tcfs_server *server, struct tcfs_fh *dir,
			    const char *name, const char *path, struct tcfs_sattr *sattr);
extern int tcfs_proc_mkdir(struct tcfs_server *server, struct tcfs_fh *dir,
			  const char *name, struct tcfs_sattr *sattr,
			  struct tcfs_fh *fhandle, struct tcfs_fattr *fattr);
extern int tcfs_proc_rmdir(struct tcfs_server *server, struct tcfs_fh *dir,
			  const char *name);
extern int tcfs_proc_readdir(struct tcfs_server *server, struct tcfs_fh *fhandle,
			    int cookie, int count, struct tcfs_entry *entry);
extern int tcfs_proc_statfs(struct tcfs_server *server, struct tcfs_fh *fhandle,
			    struct tcfs_fsinfo *res);
extern int tcfs_proc_read_request(struct tcrpc_ioreq *, struct tcfs_server *,
				 struct tcfs_fh *, unsigned long offset,
				 unsigned long count, __u32 *buf);
extern int tcfs_proc_read_reply(struct tcrpc_ioreq *, struct tcfs_fattr *);
extern int *tcrpc_header(int *p, int procedure, int program, int version,
				int uid, int gid, int *groups);
extern int *tcrpc_verify(int *p);

/* linux/fs/tcfs/sock.c */

extern int tcfs_tcrpc_call(struct tcfs_server *server, int *start,
				int *end, int size);
extern int tcfs_tcrpc_doio(struct tcfs_server *server, struct tcrpc_ioreq *,
				int async);

/* linux/fs/tcfs/inode.c */

extern struct super_block *tcfs_read_super(struct super_block *sb, 
					  void *data,int);
extern int init_tcfs_fs(void);
extern struct inode *tcfs_fhget(struct super_block *sb, struct tcfs_fh *fhandle,
			       struct tcfs_fattr *fattr);
extern void tcfs_refresh_inode(struct inode *inode, struct tcfs_fattr *fattr);

/* linux/fs/tcfs/file.c */

extern struct inode_operations tcfs_file_inode_operations;

/* linux/fs/tcfs/dir.c */

extern struct inode_operations tcfs_dir_inode_operations;
extern void tcfs_sillyrename_cleanup(struct inode *);
extern void tcfs_kfree_cache(void);

/* linux/fs/tcfs/symlink.c */

extern struct inode_operations tcfs_symlink_inode_operations;

/* linux/fs/tcfs/mmap.c */

extern int tcfs_mmap(struct inode * inode, struct file * file, struct vm_area_struct * vma);

/* linux/fs/tcfs/bio.c */

extern int tcfs_readpage(struct inode *, struct page *);

/* TCFS root */

#define TCFS_ROOT		"/tftpboot/%s"
#define TCFS_ROOT_NAME_LEN	256
#define TCFS_ROOT_ADDRS_LEN	128

extern int tcfs_root_mount(struct super_block *sb);
extern int tcfs_root_init(char *tcfsname, char *tcfsaddrs);
extern char tcfs_root_name[];
extern char tcfs_root_addrs[];

#endif /* __KERNEL__ */

#endif
