/*
 * T.C.F.S. Utils 2.0 $Revision: 1.7 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/src/RCS/tcfserrors.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.7 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 14:12:28 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfserrors.c,v 1.7 1998/01/19 14:12:28 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <unistd.h>
#include "tcfserrors.h"

void tcfs_error (int error_type, char *custom_message)
{
	if (error_type!=ER_CUSTOM && error_type!=OK)
		fprintf (stderr, "Error: ");
	
	switch (error_type)
	{
		case ER_AUTH:
		case ER_MEM:
		case ER_TCFS:
		case ER_PERM:
		case ER_ENABLE:
		case ER_DISABLE:
		case ER_COUNT:
		case ER_USER:
		case OK:
			fprintf (stderr, "%s\n", tcfs_errors_strings[error_type]);
			exit (error_type);
		case ER_CUSTOM:
			fprintf (stderr, "%s\n", custom_message);
			exit (1);
		case ER_UNKOPT:
			if (custom_message)
				fprintf (stderr, "%s: %s\n", tcfs_errors_strings[error_type], custom_message);
			else
				fprintf (stderr, "%s\n", tcfs_errors_strings[error_type]);
			
			exit (error_type);
			break; /* Useless code */
		default:
			fprintf (stderr, "internal error.\n");
			exit (1);
	}
}
