/*
 * T.C.F.S. Utils 2.0 $Revision: 1.9 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/src/RCS/tcfsrmuser.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.9 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 14:12:28 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsrmuser.c,v 1.9 1998/01/19 14:12:28 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>

#include "tcfserrors.h"
#include "tcfslib.h"

static struct option long_options[]=
{
	{ "login", 0, NULL, 'l' },
	{ "help", 0, NULL, 'h' },
	{ "verbose", 0, NULL, 'v' },
	{ 0, 0, 0, 0 }
};

char *usage="Usage: %s [OPTION]...
Remove a user entry from the TCFS dabatase.

  -l [--login] user   Username to remove from the TCFS database
  -h [--help]         Shows this help
  -v [--verbose]      Be more verbose\n";

int main (int argn, char *argv[])
{
	int index, have_user=FALSE;
	int be_verbose=FALSE;
	char *user, *passwd;
	tcfspwdb *user_info;
	int val;

	/*
	 * Going to check the arguments
	 */

	 user=(char *) malloc(20);

	 while ((val=getopt_long (argn, argv, "l:hv", long_options, &index))!=EOF)
                switch (val)
		{
			case 'l':
				strncpy (user, optarg, 9);
				have_user=TRUE;
				break;

			case 'h':
				show_usage (usage, argv[0]);
				exit (OK);
				break;
	
			case 'v':
				be_verbose=TRUE;
				break;
	
			default:
				exit (ER_UNKOPT);
				break;
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

	/*
	 * Here we don't have to drop root privileges because only root
	 * should run us.
	 * However we can do better. Maybe in next versions.
	 */
	if (!have_user)
	{
		printf ("Username to remove from TCFS database: ");
		gets (user);
	}

	if (be_verbose)
		printf ("Deleting the entry for user %s from the TCFS database...\n", user);

	/*
	 * Deleting an entry from the key database
	 */
	if (!tcfspwdbr_new (&user_info))
		tcfs_error (ER_MEM, NULL);

	if (!tcfspwdbr_edit (user_info, F_USR, user))
		tcfs_error (ER_MEM, NULL);

	if (!tcfs_putpwnam (user, user_info, U_DEL))
		tcfs_error (ER_CUSTOM, "Error: cannot remove user.\n");

	if (be_verbose)
		printf ("User entry removed with success.\n");

	tcfs_error (OK, NULL);
}
