/*
 * T.C.F.S. Utils 2.0 $Revision: 1.1 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33-tcfs/fs/tcfs/contrib/utils/src/RCS/tcfsviewkey.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.1 $
 *       $Author: anidel $
 *         $Date: 1998/01/19 14:12:09 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsviewkey.c,v 1.1 1998/01/19 14:12:09 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <strings.h>
#include <getopt.h>
#include <unistd.h>

#include "tcfserrors.h"
#include "tcfslib.h"

/* Long command line options */
static struct option long_options[]=
{
	{ "help", 0, NULL, 'h' },
	{ "count", 0, NULL, 'c' },
	{ "key", 0, NULL, 'k' },
	{ "permanent", 0, NULL, 'p' },
	{ 0, 0, 0, 0 }
};

/* Usage output */
char *usage="Usage: %s [OPTION]
Shows some useful infos about your TCFS login.

  -p [--permanent] Shows the permanent flag
  -k [--key]       Shows the key from the database
  -c [--count]     Shows the key counter (default)
  -h [--help]      Shows this help\n";

int main (int argn, char *argv[])
{
	int val, index;
	int show_key=FALSE, show_counter=FALSE, show_permanent=FALSE;
	char *user, *passwd;
	char *key, *uukey;
	tcfspwdb *userinfo;

	/*
	 * Check the command line parameters
	 */
	while((val=getopt_long (argn, argv, "hcpk", long_options, &index)) !=EOF)
		switch (val)
		{
			case 'p':
				show_permanent=TRUE;
				break;
			case 'k':
				show_key=TRUE;
				break;
			case 'c':
				show_counter=TRUE;
				break;
			case 'h':
				show_usage(usage, argv[0]);
				exit (OK);
				break;     /* Useless code */
			default:
				exit (ER_UNKOPT);
				break;     /* Useless code */
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

	if (!show_counter && !show_key && !show_permanent)
		show_counter=TRUE;


	/*
	 * Authenticate the user if he want to show his key
	 */
	if (show_key)
	{
		unix_auth(&user, &passwd);

		if (!tcfspwdbr_new(&userinfo))
			tcfs_error (ER_MEM, NULL);

		if (!tcfs_getpwnam(user, userinfo))
			tcfs_error (ER_TCFS, NULL);

		if ((key=(char *) calloc(KEYSIZE, sizeof (char)))==NULL)
			tcfs_error (ER_MEM, NULL);
	
		/* Decrypt the tcfs user key */
		if (!tcfs_decrypt_key(user, passwd, userinfo->upw, &key))
			tcfs_error (ER_CUSTOM, "Error: unable to decrypt key.\n");

		uukey = tcfs_encode (key, KEYSIZE);
	
		printf("TCFS key:\n%s\n", uukey);
	}

	if (show_counter){
		if((val=tcfs_getcount (getlogin()))<0){
			tcfs_error(ER_CUSTOM, "TCFS counter: no TCFS filesystem mounted or no key present.");
		}
		else 
		printf ("TCFS counter: %d\n", val);
	}

	if (show_permanent){
		if((val=tcfs_getpermanent(getlogin()))<0){
			tcfs_error(ER_CUSTOM, "TCFS permanent: no TCFS filesystem mounted or no key present.");
		}
		else
		printf ("TCFS permanent flag: %s\n", val?"set":"unset");
	}
}
