/*
 * T.C.F.S. Utils 2.0 $Revision: 2.0 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /home/anidel/Wip/TCFS-2.2.0a/tcfslib-0.2/include/RCS/tcfserrors.h,v $
 *        $State: Exp $
 *
 *     $Revision: 2.0 $
 *       $Author: anidel $
 *         $Date: 1998/10/22 08:38:47 $
 *       $Locker:  $
 */              
/* -+-_== */ 

#ifndef _ERRORS_H
#define _ERRORS_H

enum
{
	OK=0,          /* Ok, no error */
	ER_CUSTOM,     /* Custom error message */
	ER_UNKOPT,     /* Unknown command line option */
	ER_AUTH,       /* User authentication error */
	ER_MEM,        /* Out of memory error */
	ER_TCFS,       /* User is not allowed to use TCFS */
	ER_USER,			/* User error */
	ER_PERM,       /* Error calling TCFS_IOC_PERMANENT ioctl */
	ER_ENABLE,     /* Error calling TCFS_IOC_LOGIN ioctl */
	ER_DISABLE,    /* Error calling TCFS_IOC_DISABLE ioctl */
	ER_COUNT       /* Error calling TCFS_IOC_COUNT ioctl */
};

static char *tcfs_errors_strings[]=
{
	"Ok",
	NULL,
	"unknow option.",
	"authentication error.",
	"out of memory.",
	"you do not have a TCFS key.",
	"Who are you?!",
	"ioctl error while setting permanent flag.",
	"ioctl error while sending.",
	"ioctl error while removing key.",
	"ioctl error while getting key counter."
};

void tcfs_error (int error_type, char *arg);

#endif

/* End of errors.h */
