#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/malloc.h>
#include <linux/kerneld.h>
#include <linux/tcfs/tcfsapi.h>

static struct tcfs_cipher_hook *tcfs_hook_start=NULL;

void tcfs_register_cipher (char *cipher, struct tcfs_cipher_operations *cipher_ops)
{
	struct tcfs_cipher_hook *tmp=tcfs_hook_start;

	if (tcfs_hook_start==NULL) {
		tcfs_hook_start=(struct tcfs_cipher_hook *)kmalloc (sizeof (struct tcfs_cipher_hook), GFP_KERNEL);
		strncpy (tcfs_hook_start->cipher_name, cipher, TCFS_CIPHERNAME_LEN);
		tcfs_hook_start->cipher_ops=cipher_ops;
		tcfs_hook_start->next=NULL;

		return; 
	}

	do {
		if (!strcmp (cipher, tmp->cipher_name)) {
			printk ("TCFS: cipher module yet loaded\n");
			return ;
		}       
	} while (tmp->next && (tmp=tmp->next));

	tmp->next=(struct tcfs_cipher_hook *)kmalloc (sizeof (struct tcfs_cipher_hook), GFP_KERNEL);
	tmp=tmp->next;
	strncpy (tmp->cipher_name, cipher, TCFS_CIPHERNAME_LEN);
	tmp->cipher_ops=cipher_ops;
	tmp->next=NULL;
}

void tcfs_unregister_cipher (char *cipher)
{
	struct tcfs_cipher_hook *tmp=tcfs_hook_start;
	struct tcfs_cipher_hook *prev=tcfs_hook_start;

	do {
		if (tmp && !strcmp(tmp->cipher_name, cipher)) {
			prev->next=tmp->next;
			kfree (tmp);

			if (tmp==tcfs_hook_start) {
				tcfs_hook_start=NULL;
			}

			return;
		}
		prev=tmp;
	} while (tmp && (tmp=tmp->next));
}

struct tcfs_cipher_operations *tcfs_cipher_lookup (char *cipher_name)
{
	struct tcfs_cipher_hook *tmp=tcfs_hook_start;
	char *cipher_module=NULL;

	do {
		if (tmp && (!strcmp(tmp->cipher_name, cipher_name))) {
				return tmp->cipher_ops;
		}
	} while (tmp && (tmp=tmp->next));

	cipher_module=(char *)kmalloc (13+strlen(cipher_name), GFP_KERNEL);
	if (!cipher_module) {
		printk ("TCFS: not enough memory\n");
		return NULL;
	}

	sprintf (cipher_module, "tcfs_%s_cipher", cipher_name);

	if (request_module(cipher_module)) {
		printk ("TCFS: an error occurred loading %s module\n", cipher_name);
		return NULL;
	}

	kfree (cipher_module);

	return tcfs_cipher_lookup (cipher_name);
}

void tcfs_encrypt (char *block, int bytes, void *key)
{
	struct tcfs_cipher_operations *tmp;

	tmp=tcfs_cipher_lookup ("default");

	if (tmp && tmp->encrypt) {
		tmp->encrypt(block, bytes, key);
	}
}

void tcfs_decrypt (char *block, int bytes, void *key)
{
	struct tcfs_cipher_operations *tmp;

	tmp=tcfs_cipher_lookup ("default");
	if (tmp && tmp->decrypt) {
		tmp->decrypt(block, bytes, key);
	}
}

void *tcfs_init_key (char *key)
{
	struct tcfs_cipher_operations *tmp;
	void *ret=NULL;

	tmp=tcfs_cipher_lookup ("default");
	if (tmp && tmp->init_key) {
		ret=tmp->init_key(key);
	}

	return ret;
}

void tcfs_cleanup_key (void *key)
{
	struct tcfs_cipher_operations *tmp;

	tmp=tcfs_cipher_lookup ("default");
	if (tmp && tmp->cleanup_key) {
		tmp->cleanup_key (key);
	}
}
