#ifndef _TCFS_FS_I
#define _TCFS_FS_I

#include <linux/tcfs.h>
#include <linux/pipe_fs_i.h>
#include <asm/semaphore.h>
/*
 * tcfs fs inode data in memory
 */
struct tcfs_inode_info {
	struct pipe_inode_info pipeinfo;
	struct tcfs_fh fhandle;
	/*
	 * read_cache_jiffies is when we started read-caching this inode,
	 * and read_cache_mtime is the mtime of the inode at that time.
	 *
	 * We need to invalidate the cache for this inode if
	 *
	 *	jiffies - read_cache_jiffies > 30*HZ
	 * AND
	 *	mtime != read_cache_mtime
	 */
	unsigned long read_cache_jiffies;
	unsigned long read_cache_mtime;
	/*
	 * This is to support the clandestine rename on unlink.
	 * Instead of the directory inode, we might as well keep its
	 * TCFS FH, but that requires a kmalloc.
	 */
	struct inode *silly_rename_dir;
	/*
	 * attrtimeo defines for how long the cached attributes are valid
	 */
	unsigned int readcount;
	unsigned long attrtimeo;
	char pathname[TCFS_MAXPATHLEN+1];
	union {
		unsigned int cflag; 
		struct {
			unsigned int ext2:7;
			unsigned int mb:1;
			unsigned int spure:3;
			unsigned int gshar:1;
			unsigned int unknow:20;
/*
			unsigned int unknow:20;
			unsigned int mb:1;
			unsigned int gshar:1;
			unsigned int spure:3;
*/
		} bf;
	} tcfs_fl;
	struct semaphore mutex;
	struct semaphore wrt;
};

#endif
