/*
 * T.C.F.S. Utils 2.0 $Revision: 2.0 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /home/anidel/Wip/TCFS-2.2.0a/tcfsutils-1.1/src/RCS/unix_auth.c,v $
 *        $State: Exp $
 *
 *     $Revision: 2.0 $
 *       $Author: anidel $
 *         $Date: 1998/10/22 08:40:09 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: unix_auth.c,v 2.0 1998/10/22 08:40:09 anidel Exp $";
/* -+-_== */ 

/* Thanks to Usui Takayuki (takajuki@satan.genesis.ne.jp) for the
 * Shadow Password support
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <tcfslib.h>

#ifdef SHADOW_PASSWORD
#include <shadow.h>
#else
#include <pwd.h>
#endif

#include "tcfserrors.h"

int unix_auth (char **user, char **password, int flag)
{
	char *luser, *passwd;
#ifdef SHADOW_PASSWORD
	struct spwd *sp;
#else
	struct passwd *passentry;
#endif

	luser=(char*)calloc (MAXUSERLOGIN_LEN, sizeof(char));
	passwd=(char*)calloc (_PASSWORD_LEN, sizeof(char));

	if (!luser || !passwd)
		tcfs_error (ER_MEM, NULL);

	if (flag)
		strcpy (luser, getlogin());
	else
	{
		printf ("Enter user: ");
		gets (luser);
	}

	strcpy (passwd, getpass ("password:"));
	
#ifdef SHADOW_PASSWORD
	if ((sp=getspnam(luser))==NULL)
	{
		bzero (passwd, strlen(passwd));
		return 0;
	}

	if (strcmp(crypt (passwd, sp->sp_pwdp), sp->sp_pwdp))
	{
#else
	if ((passentry=getpwnam(luser))==NULL)
	{
		bzero (passwd, strlen(passwd));
		return 0;
	}

	if (strcmp (crypt (passwd, passentry->pw_passwd), passentry->pw_passwd))
	{
#endif
		return 0;
	}

	*user=luser;
	*password=passwd;

	return 1;
}
