#ifndef _LINUX_TCFS_H
#define _LINUX_TCFS_H

#define TCFS_PORT 2049
#define TCFS_MAXDATA 8192
#define TCFS_MAXPATHLEN 1024
#define TCFS_MAXNAMLEN 255
#define TCFS_MAXGROUPS 16
#define TCFS_FHSIZE 32
#define TCFS_COOKIESIZE 4
#define TCFS_FIFO_DEV (-1)
#define TCFSMODE_FMT 0170000
#define TCFSMODE_DIR 0040000
#define TCFSMODE_CHR 0020000
#define TCFSMODE_BLK 0060000
#define TCFSMODE_REG 0100000
#define TCFSMODE_LNK 0120000
#define TCFSMODE_SOCK 0140000
#define TCFSMODE_FIFO 0010000

#define TCFS_SEMW_DOWN(x)	down(&(x->u.tcfs_i.wrt)); 
#define TCFS_SEMW_UP(x)		up(&(x->u.tcfs_i.wrt));
#define TCFS_SEMR_DOWN(x)	down(&(x->u.tcfs_i.mutex)); \
				x->u.tcfs_i.readcount++; \
				if (x->u.tcfs_i.readcount==1) down(&(x->u.tcfs_i.wrt)); \
				up(&(x->u.tcfs_i.mutex)); 
#define TCFS_SEMR_UP(x)		down(&(x->u.tcfs_i.mutex)); \
				x->u.tcfs_i.readcount--; \
				if (x->u.tcfs_i.readcount==0) up(&(x->u.tcfs_i.wrt)); \
				up(&(x->u.tcfs_i.mutex)); 
#define TCFS_SECURE_FL	0x00000080
#define TCFS_SIZE_BITS	0x00000700
#define TCFS_GSHARED_FL	0x00000800
#define TCFS_IS_SECURE(x)	(x & TCFS_SECURE_FL)
/*
#define TCFS_IS_SHARED(x)	((x)->u.tcfs_i.tcfs_fl.cflag & TCFS_GSHARED_FL)
*/
#define TCFS_IS_SHARED(x)	((x)->u.tcfs_i.tcfs_fl.bf.gshar==1)
extern void tcfsencode(char *,int);
extern int tcfsdecode(char *,int);

 
#ifdef __KERNEL__ /* user programs should get these from the rpc header files */

#define TCRPC_VERSION 2

enum tcrpc_auth_flavor {
	TCRPC_AUTH_NULL = 0,
	TCRPC_AUTH_UNIX = 1,
	TCRPC_AUTH_SHORT = 2
};

enum tcrpc_msg_type {
	TCRPC_CALL = 0,
	TCRPC_REPLY = 1
};

enum tcrpc_reply_stat {
	TCRPC_MSG_ACCEPTED = 0,
	TCRPC_MSG_DENIED = 1
};

enum tcrpc_accept_stat {
	TCRPC_SUCCESS = 0,
	TCRPC_PROG_UNAVAIL = 1,
	TCRPC_PROG_MISMATCH = 2,
	TCRPC_PROC_UNAVAIL = 3,
	TCRPC_GARBAGE_ARGS = 4
};

enum tcrpc_reject_stat {
	TCRPC_MISMATCH = 0,
	TCRPC_AUTH_ERROR = 1
};

enum tcrpc_auth_stat {
	TCRPC_AUTH_BADCRED = 1,
	TCRPC_AUTH_REJECTEDCRED = 2,
	TCRPC_AUTH_BADVERF = 3,
	TCRPC_AUTH_REJECTEDVERF = 4,
	TCRPC_AUTH_TOOWEAK = 5
};

#endif /* __KERNEL__ */
	
enum tcfs_stat {
	TCFS_OK = 0,
	TCFSERR_PERM = 1,
	TCFSERR_NOENT = 2,
	TCFSERR_IO = 5,
	TCFSERR_NXIO = 6,
	TCFSERR_EAGAIN = 11,
	TCFSERR_ACCES = 13,
	TCFSERR_EXIST = 17,
	TCFSERR_NODEV = 19,
	TCFSERR_NOTDIR = 20,
	TCFSERR_ISDIR = 21,
	TCFSERR_INVAL = 22,	/* that Sun forgot */
	TCFSERR_FBIG = 27,
	TCFSERR_NOSPC = 28,
	TCFSERR_ROFS = 30,
	TCFSERR_NAMETOOLONG = 63,
	TCFSERR_NOTEMPTY = 66,
	TCFSERR_DQUOT = 69,
	TCFSERR_STALE = 70,
	TCFSERR_WFLUSH = 99
};

enum tcfs_ftype {
	TCNON = 0,
	TCREG = 1,
	TCDIR = 2,
	TCBLK = 3,
	TCCHR = 4,
	TCLNK = 5,
	TCFSOCK = 6,
	TCBAD = 7,
	TCFIFO = 8
};

#define TCFS_PROGRAM		100003
#define TCFS_VERSION		2
#define TCFS_VERSION_MINOR	2
#define TCFSPROC_NULL		0
#define TCFSPROC_GETATTR		1
#define TCFSPROC_SETATTR		2
#define TCFSPROC_ROOT		3
#define TCFSPROC_LOOKUP		4
#define TCFSPROC_READLINK	5
#define TCFSPROC_READ		6
#define TCFSPROC_WRITECACHE	7
#define TCFSPROC_WRITE		8
#define TCFSPROC_CREATE		9
#define TCFSPROC_REMOVE		10
#define TCFSPROC_RENAME		11
#define TCFSPROC_LINK		12
#define TCFSPROC_SYMLINK		13
#define TCFSPROC_MKDIR		14
#define TCFSPROC_RMDIR		15
#define TCFSPROC_READDIR		16
#define TCFSPROC_STATFS		17

#define NUM_CIPHER		4
#define CIPHER_NONE		0
#define CIPHER_DES		1
#define CIPHER_IDEA		2
#define CIPHER_RC5		3

struct tcfs_fh {
	char data[TCFS_FHSIZE];
};

struct tcfs_time {
	u_int seconds;
	u_int useconds;
};

struct tcfs_fattr {
	enum tcfs_ftype type;
	u_int mode;
	u_int nlink;
	u_int uid;
	u_int gid;
	u_int size;
	u_int blocksize;
	u_int rdev;
	u_int blocks;
	u_int fsid;
	u_int fileid;
	struct tcfs_time atime;
	struct tcfs_time mtime;
	struct tcfs_time ctime;
};

struct tcfs_sattr {
	u_int mode;
	u_int uid;
	u_int gid;
	u_int size;
	struct tcfs_time atime;
	struct tcfs_time mtime;
};

struct tcfs_entry {
	u_int fileid;
	char *name;
	int cookie;
	int eof;
};

struct tcfs_fsinfo {
	u_int tsize;
	u_int bsize;
	u_int blocks;
	u_int bfree;
	u_int bavail;
};

#endif
