/*
 * T.C.F.S. 2.0 $Revision: 1.1 $
 *
 *      	This program handles RPC "TCFS" data requests 
 *              adopting a secure transfer protocol.
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 *
 */

/*
 *       $Source: /usr/src/tcfs-current/RCS/tcrpcsock.h,v $
 *        $State: Exp $
 *
 *     $Revision: 1.1 $ 
 *       $Author: andcoz $
 *         $Date: 1996/09/18 13:21:35 $
 *       $Locker: ermmau $
 */              

/*
 * $Log: tcrpcsock.h,v $
 * Revision 1.1  1996/09/18 13:21:35  andcoz
 * Initial revision
 *
 *
 */

/* -+-_== */


/*
 *  tcrpcsock.h	Declarations for the RPC call interface.
 *
 *  Copyright (C) 1995, 1996 Olaf Kirch <okir@monad.swb.de>
 */


#ifndef _LINUX_TCRPCSOCK_H
#define _LINUX_TCRPCSOCK_H

/*
 * The rpcsock code maintains an estimate on the maximum number of out-
 * standing RPC requests, using the congestion avoidance implemented in
 * 44BSD. This is basically the Van Jacobson slow start algorithm: If a
 * retransmit occurs, the congestion window is halved; otherwise, it is
 * incremented by 1/cwnd when a reply is received and a full number of
 * requests are outstanding.
 *
 * Upper procedures may check whether a request would block waiting for
 * a free RPC slot by using the TCRPC_CONGESTED() macro.
 *
 * Note: on machines with low memory we should probably use a smaller
 * MAXREQS value: At 32 outstanding reqs with 8 megs of RAM, fragment
 * reassembly will frequently run out of memory.
 */
#define TCRPC_MAXREQS		32
#define TCRPC_CWNDSCALE		256
#define TCRPC_MAXCWND		(TCRPC_MAXREQS * TCRPC_CWNDSCALE)
/* #define TCRPC_INITCWND		(TCRPC_MAXCWND / 2) */
#define TCRPC_INITCWND		TCRPC_CWNDSCALE
#define TCRPC_CONGESTED(rsock)	((rsock)->cong >= (rsock)->cwnd)

/* RPC reply header size: xid, direction, status, accept_status (verifier
 * size computed separately)
 */
#define TCRPC_HDRSIZE		(4 * 4)

/*
 * This describes a timeout strategy
 */
struct tcrpc_timeout {
	unsigned long		to_initval,
				to_maxval,
				to_increment;
	int			to_retries;
	char			to_exponential;
};

/*
 * This describes a complete RPC request
 */
struct tcrpc_ioreq {
	struct tcrpc_wait *	rq_slot;
	struct sockaddr	*	rq_addr;
	int			rq_alen;
	struct iovec		rq_svec[UIO_MAXIOV];
	unsigned int		rq_snr;
	unsigned long		rq_slen;
	struct iovec		rq_rvec[UIO_MAXIOV];
	unsigned int		rq_rnr;
	unsigned long		rq_rlen;
};

/*
 * This is the callback handler for async RPC.
 */
struct tcrpc_wait;
typedef void	(*tcrpc_callback_fn_t)(int, struct tcrpc_wait *, void *);

/*
 * Wait information. This struct defines all the state of an RPC
 * request currently in flight.
 */
struct tcrpc_wait {
	struct tcrpc_sock *	w_sock;
	struct tcrpc_wait *	w_prev;
	struct tcrpc_wait *	w_next;
	struct tcrpc_ioreq *	w_req;
	int			w_result;
	struct wait_queue *	w_wait;
	tcrpc_callback_fn_t	w_handler;
	void *			w_cdata;
	char			w_queued;
	char			w_gotit;
	__u32			w_xid;
};

struct tcrpc_sock {
	struct file *		file;
	struct socket *		sock;
	struct sock *		inet;
	struct tcrpc_wait		waiting[TCRPC_MAXREQS];
	unsigned long		cong;
	unsigned long		cwnd;
	struct tcrpc_wait *	pending;
	struct tcrpc_wait *	free;
	struct wait_queue *	backlog;
	struct wait_queue *	shutwait;
	int			shutdown;
};

#ifdef __KERNEL__

/* tcrpc_call: Call synchronously */
int			tcrpc_call(struct tcrpc_sock *, struct tcrpc_ioreq *,
					 struct tcrpc_timeout *);
/* These implement asynch calls for tcfsiod: Process calls tcrpc_reserve and
 * tcrpc_transmits, then passes the request to tcfsiod, which collects the
 * results via tcrpc_doio
 */
int			tcrpc_reserve(struct tcrpc_sock *, struct tcrpc_ioreq *, int);
void			tcrpc_release(struct tcrpc_sock *, struct tcrpc_ioreq *);
int			tcrpc_transmit(struct tcrpc_sock *, struct tcrpc_ioreq *);
int			tcrpc_doio(struct tcrpc_sock *, struct tcrpc_ioreq *,
					 struct tcrpc_timeout *, int);
struct tcrpc_sock	*	tcrpc_makesock(struct file *);
int			tcrpc_closesock(struct tcrpc_sock *);

#endif /* __KERNEL__*/

#endif /* _LINUX_RPCSOCK_H */
