/*

    ``gpgp'' Gnome/GTK Front for PGP
    Copyright (C) 1998  Max Valianskiy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: decrypt.c,v 1.2 1998/09/03 07:54:31 maxcom Stab $ 

*/

#include <gnome.h>
#include "../include/gpgp.h"
#include "client.h"

GtkWidget *app;
GnomePgpUnSign *sign;

int context;

void sign_cancel_cb (GtkWidget *widget, void *data)
{
 gnome_error_dialog(_("Canceled by user"));
 gtk_widget_destroy(widget);
}   

void sign_error_cb (GtkWidget *widget, void *data)
{
 gnome_error_dialog(GNOME_PGP_UNSIGN(data)->error_info);
 gtk_widget_destroy(widget);
}   

void sign_destroy_cb (GtkWidget *widget, void *data)
{
  if (!GNOME_PGP_UNSIGN(widget)->error_info && GNOME_PGP_UNSIGN(widget)->obuf)
    {
     int docid = client_document_new( context, "decrypted file" );
     client_text_append( docid, GNOME_PGP_UNSIGN(data)->obuf, GNOME_PGP_UNSIGN(data)->obufsize);

     client_document_show( docid );
    }

  client_finish( context );

  exit(0);
}

int main( int argc, char *argv[] )
{
  int docid;
  int length;
  gchar *buff;
  client_info info;

  info.menu_location = "[Plugins]PGP Decrypt";

  context = client_init( &argc, &argv, &info );

  docid = client_document_current( context );
  length = strlen( buff = client_text_get( docid ) );

  if (!length || !buff) return -1;

  gnome_init ("gpgp-plugin", NULL, argc, argv, 0, NULL);
  app = gnome_app_new ("gpgp-plugin", "GnomePGP plugin");
  gpgp_init(GNOME_APP(app), 1);
  gtk_widget_realize (app);

  sign=GNOME_PGP_UNSIGN(gnome_pgp_unsign_new(buff,length));
  gtk_signal_connect (GTK_OBJECT (sign), "error",GTK_SIGNAL_FUNC (sign_error_cb),sign);
  gtk_signal_connect (GTK_OBJECT (sign), "cancel",GTK_SIGNAL_FUNC (sign_cancel_cb),sign);
  gtk_signal_connect (GTK_OBJECT (sign), "destroy",GTK_SIGNAL_FUNC (sign_destroy_cb),sign);
 
  gtk_widget_show(GTK_WIDGET(sign));

  gnome_pgp_unsign_action(sign);

  gtk_main();

  return 0;
}
