#include <stdio.h>
#include <zlib.h>
#include <string.h>

#define NTPKTP 12
#define NTPSIZ (1<<NTPKTP)

#define OBSIZ (8128+NTPSIZ*2)
#define IBSIZ 10240
int pgpcomp5(FILE * inf, FILE * outf)
{
  z_stream pgpz;

  int readgot, isav;
  unsigned char ibuf[IBSIZ], obuf[OBSIZ];

  pgpz.zalloc = (alloc_func) 0;
  pgpz.zfree = (free_func) 0;
  pgpz.opaque = (voidpf) 0;

  fputc(0xc8, outf);
  obuf[0] = 1;
  pgpz.next_out = obuf + 1, pgpz.avail_out = OBSIZ - 1;

  deflateInit2(&pgpz, Z_DEFAULT_COMPRESSION, Z_DEFLATED, -13, 8, 0);

  readgot = IBSIZ;
  while (!feof(inf) && readgot == IBSIZ) {
    if (0 >= (readgot = fread(ibuf, 1, IBSIZ, inf)))
      break;
    pgpz.next_in = ibuf;
    pgpz.avail_in = readgot;
    while (pgpz.avail_in || readgot != IBSIZ) {
      isav = deflate(&pgpz, readgot == IBSIZ ? 0 : Z_FINISH);
      while (OBSIZ - pgpz.avail_out >= 8128 + NTPSIZ * (readgot == IBSIZ)) {
        fputc(0xe0 + NTPKTP, outf);
        fwrite(obuf, 1, NTPSIZ, outf);
        memmove(obuf, &obuf[NTPSIZ], OBSIZ - pgpz.avail_out - NTPSIZ);
        pgpz.avail_out += NTPSIZ;
        pgpz.next_out -= NTPSIZ;
      }
      if (isav != Z_OK)
        break;
    }
  }

  if (OBSIZ - pgpz.avail_out > 192) {
    fputc(0xc0 | ((OBSIZ - pgpz.avail_out - 192) >> 8), outf);
    fputc(OBSIZ - pgpz.avail_out - 192, outf);
  } else
    fputc(OBSIZ - pgpz.avail_out, outf);
  fwrite(obuf, 1, OBSIZ - pgpz.avail_out, outf);
  return 0;
}
