#include <stdlib.h>
#include "libopgp.h"

extern int PGP_gtblk(UCHAR * b, int get, int *len, int *neof, FILE *);
/* should be > 8128 */
#define RBSIZ 10000
/* won't work for multiples with different lengths, but to mark where... */
#define BSZ 8

int PGP_cdec(FILE * inf, FILE * outf, void *cfbdat[], int cfbcnt)
{
  UCHAR dbuf[RBSIZ];
  unsigned int k, j, ll, neof, cc = 0;

  ll = fgetc(inf);
  neof = 0;
  if (ll != 0xc9 && (ll & 0xfc) != 0xa4) {
    free(cfbdat);
    return -3;
  }
  if (ll == 0xc9)
    ll = PGP_nxpkt(&neof, inf);
  else {
    j = 1 << (ll & 3);
    for (k = 0, ll = 0; k < j; k++)
      ll = (ll << 8) + fgetc(inf);
  }
  if (PGP_gtblk(dbuf, BSZ + 2, &ll, &neof, inf))
    return -5;
  memcpy(&dbuf[BSZ + 2], dbuf, BSZ + 2);
  for (;;) {                    /* test each key context */
    PGP_cblk(dbuf, BSZ + 2, cfbdat[cc]);
    if (dbuf[BSZ - 2] == dbuf[BSZ] && dbuf[BSZ - 1] == dbuf[BSZ + 1])
      break;
    free(cfbdat[cc++]);
    if (cc == cfbcnt)
      return -7;
    else
      memcpy(dbuf, &dbuf[BSZ + 2], BSZ + 2);
  }
  PGP_cres(&dbuf[BSZ + 4], cfbdat[cc]);  /* PGP special restart */
  while (ll) {                  /* depacket and decrypt */
    k = ll > RBSIZ ? RBSIZ : ll;
    if (0 >= (j = fread(dbuf, 1, k, inf)))
      exit(-2);
    PGP_cblk(dbuf, j, cfbdat[cc]);
    k = fwrite(dbuf, 1, j, outf);
    ll -= j;
    if (!ll && neof)
      ll = PGP_nxpkt(&neof, inf);
  }
  while (cc < cfbcnt)
    free(cfbdat[cc++]);
  return 0;
}
