/* pgginput.h - data structure definition of PggInput
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGINPUT_H_19990609134234
#define PGG_INCLUDE_PGGINPUT_H_19990609134234


#include <pggimpl.h>


_mktype(PggInput)
{
    unsigned long	magic;
    int			refcounter;
    int			state;	/* 1 = filename, 2 = buffer, 3 = FD, 4 = raw data */
    int			fd;
    long		bytes_read;
    union {
        char *		filename;
        PggBuffer	buf;
        struct {
            char *	ptr;
            long	size;
        } raw;
    } data;
};

_mktypeptr(PggInput);


#define PggInputMAGIC 0xFF0F0299


#endif


