/* buffer-3.test.c - test for pgg_buffer_set_wipeout()
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pgg.h>
#include <string.h>


int main()
{
    PggErrenv		errenv;
    PggBuffer		buffer;
    char *		help;
    int			i;
    
    pgg_errenv_reset(errenv);
    
    buffer = pgg_buffer_new(errenv);
    pgg_buffer_set_wipeout(buffer, 1, errenv);
    
    for(i=1; i<1000; ++i)
        pgg_buffer_append(buffer, "0123456789", 10, errenv);
    
    /*
     * This sequence should clear the wole buffer data
     */
    pgg_buffer_set_size(buffer, 50000, errenv);
    pgg_buffer_set_size(buffer, 0, errenv);
    pgg_buffer_set_size(buffer, 50000, errenv);
    
    help = (char *)pgg_buffer_get_data(buffer, errenv);
    pgg_buffer_detach_data(buffer, errenv);
    pgg_buffer_release(buffer, errenv);
    
    if (pgg_errenv_is_set(errenv))
        return 1;
    
    for(i=0; i<50000; ++i)
        if (help[i] != 0)
            return 1;
    
    return 0;
}





