VERSION 4.00
Begin VB.Form frmKeyGen 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Generate Key Pair"
   ClientHeight    =   6210
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   4245
   Height          =   6615
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6210
   ScaleWidth      =   4245
   ShowInTaskbar   =   0   'False
   Top             =   1170
   Width           =   4365
   Begin VB.Frame Frame2 
      Caption         =   "User ID"
      Height          =   1335
      Left            =   180
      TabIndex        =   18
      Top             =   120
      Width           =   3855
      Begin VB.TextBox txtUserID 
         Height          =   285
         Left            =   180
         MaxLength       =   255
         TabIndex        =   0
         Top             =   900
         Width           =   3495
      End
      Begin VB.Label Label3 
         Caption         =   "John Q. Public <johnq@emailaddress.net>"
         Height          =   195
         Left            =   180
         TabIndex        =   20
         Top             =   660
         Width           =   3015
      End
      Begin VB.Label Label2 
         Caption         =   "Please enter a user ID for this key.  This is usually in the following format:"
         Height          =   435
         Left            =   180
         TabIndex        =   19
         Top             =   240
         Width           =   2835
      End
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   435
      Left            =   2160
      TabIndex        =   16
      Top             =   5580
      Width           =   1515
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   435
      Left            =   420
      TabIndex        =   15
      Top             =   5580
      Width           =   1515
   End
   Begin VB.Frame Frame1 
      Caption         =   "Key Expiration"
      Height          =   915
      Left            =   180
      TabIndex        =   11
      Top             =   4500
      Width           =   3855
      Begin VB.TextBox txtKeyExpire 
         Height          =   285
         Left            =   1440
         MaxLength       =   4
         TabIndex        =   14
         Top             =   480
         Width           =   915
      End
      Begin VB.OptionButton optKeyExpire 
         Caption         =   "Key expires in                       days (1-999)"
         Height          =   255
         Index           =   1
         Left            =   180
         TabIndex        =   13
         Top             =   540
         Width           =   3195
      End
      Begin VB.OptionButton optKeyExpire 
         Caption         =   "Key never expires"
         Height          =   255
         Index           =   0
         Left            =   180
         TabIndex        =   12
         Top             =   240
         Value           =   -1  'True
         Width           =   2775
      End
   End
   Begin VB.Frame fraKeyType 
      Caption         =   "RSA Key Type"
      Height          =   1335
      Left            =   180
      TabIndex        =   7
      Top             =   3060
      Width           =   3855
      Begin VB.OptionButton optKeyType 
         Caption         =   "RSA Sign and Verify Only"
         Height          =   255
         Index           =   2
         Left            =   180
         TabIndex        =   10
         Top             =   960
         Width           =   2835
      End
      Begin VB.OptionButton optKeyType 
         Caption         =   "RSA Encrypt and Decrypt Only"
         Height          =   255
         Index           =   1
         Left            =   180
         TabIndex        =   9
         Top             =   720
         Width           =   2955
      End
      Begin VB.OptionButton optKeyType 
         Caption         =   "RSA Encrypt, Decrypt, Sign, Verify"
         Height          =   255
         Index           =   0
         Left            =   180
         TabIndex        =   8
         Top             =   240
         Value           =   -1  'True
         Width           =   2835
      End
      Begin VB.Label Label1 
         Caption         =   "(Traditional PGP Key)"
         Height          =   255
         Left            =   420
         TabIndex        =   17
         Top             =   480
         Width           =   1695
      End
   End
   Begin VB.Frame fraKeySize 
      Caption         =   "RSA Key Size"
      Height          =   1395
      Left            =   180
      TabIndex        =   1
      Top             =   1560
      Width           =   3855
      Begin VB.TextBox txtKeySize 
         Height          =   285
         Left            =   2760
         MaxLength       =   5
         TabIndex        =   6
         Top             =   960
         Width           =   915
      End
      Begin VB.OptionButton optKeySize 
         Caption         =   "Custom key size (384-2048 bits):"
         Height          =   255
         Index           =   3
         Left            =   180
         TabIndex        =   5
         Top             =   1020
         Width           =   2655
      End
      Begin VB.OptionButton optKeySize 
         Caption         =   "2048 bits: Slowest, Best Security"
         Height          =   255
         Index           =   2
         Left            =   180
         TabIndex        =   4
         Top             =   720
         Width           =   2775
      End
      Begin VB.OptionButton optKeySize 
         Caption         =   "1024 bits: Slower, Better Security"
         Height          =   255
         Index           =   1
         Left            =   180
         TabIndex        =   3
         Top             =   480
         Value           =   -1  'True
         Width           =   2775
      End
      Begin VB.OptionButton optKeySize 
         Caption         =   "512 bits: Fast, Good Security"
         Height          =   255
         Index           =   0
         Left            =   180
         TabIndex        =   2
         Top             =   240
         Width           =   2775
      End
   End
End
Attribute VB_Name = "frmKeyGen"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Const KS_CUSTOM = 3
Const KE_CUSTOM = 1

Dim bDontChange

Private Sub cmdCancel_Click()
    Unload Me
End Sub

Private Sub cmdOK_Click()
    Dim iResult As Integer, iKeyType As Integer
    Dim sKeyID As String * 20, sNewKeyPwd As String * 255
    
    sKeyID = Chr(0)
    sNewKeyPwd = Chr(0)
    
    If Len(Trim(txtUserID.Text)) = 0 Then
        MsgBox "Please enter a user ID for this key pair.", vbInformation
        Exit Sub
    End If
    
    If optKeyType(0).Value Then iKeyType = KEYS_OLD
    If optKeyType(1).Value Then iKeyType = KEYS_ENCR
    If optKeyType(2).Value Then iKeyType = KEYS_SIGN
    
    If Val(txtKeySize.Text) < 384 Or Val(txtKeySize.Text) > 2048 Then
        MsgBox "Please specify a valid key size between 384 and 2048 bits.", vbInformation
        Exit Sub
    End If
    If optKeyExpire(1).Value Then
        If Val(txtKeyExpire.Text) < 1 Or Val(txtKeyExpire.Text) > 999 Then
            MsgBox "Please specify a valid number of days for key expiration between 1 and 999.", vbInformation
            Exit Sub
        End If
    Else
        txtKeyExpire.Text = "0"
    End If
    
    iResult = SimplePGPGenerateKey(Me.hWnd, txtUserID.Text, Val(txtKeySize.Text), iKeyType, Val(txtKeyExpire.Text), Trim(sNewKeyPwd), 255, "", "", sKeyID)
    
    If iResult = 0 Then
        MsgBox "Key pair generated successfully." + Chr(13) + Chr(10) + "Key ID: " + TrimNulls(sKeyID), vbInformation
    Else
        MsgBox "Simple PGP Generate Key returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
    
    Unload Me
End Sub


Private Sub Form_Load()
    Call optKeySize_Click(1)
    Call optKeyExpire_Click(0)
End Sub

Private Sub optKeyExpire_Click(Index As Integer)
    If Index <> KE_CUSTOM Then
        bDontChange = True
        txtKeyExpire.Text = 0
        bDontChange = False
    Else
        txtKeyExpire.SetFocus
    End If
End Sub

Private Sub optKeySize_Click(Index As Integer)
    If Index <> KS_CUSTOM Then
        bDontChange = True
        txtKeySize.Text = Val(Left(optKeySize(Index).Caption, 4))
        bDontChange = False
    Else
        txtKeySize.SetFocus
    End If
End Sub


Private Sub txtKeyExpire_Change()
    If optKeyExpire(KE_CUSTOM).Value = 0 And bDontChange = 0 Then
        optKeyExpire(KE_CUSTOM).Value = True
    End If
End Sub

Private Sub txtKeySize_Change()
    If optKeySize(KS_CUSTOM).Value = 0 And bDontChange = 0 Then
        optKeySize(KS_CUSTOM).Value = True
    End If
End Sub


