/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CGetPassphraseDialog.cp,v 1.10.8.1 1998/11/12 03:05:06 heller Exp $
____________________________________________________________________________*/

#include <LCheckBox.h>
#include <PP_Messages.h>
#include <UModalDialogs.h>
#include "pgpMacMemory.h"
#include "MacStrings.h"

#include "PGPDisk.h"
#include "PGPDiskBeta.h"
#include "PGPDiskFileFormat.h"
#include "PGPDiskResources.h"
#include "PGPDiskUtils.h"

#include "CGetPassphraseDialog.h"
#include "CPassphraseEdit.h"
#include "CPGPStDialogHandler.h"

const short		kGetPassphraseDialogResID 	= 4000;

const PaneIDT	kReadOnlyCheckboxPaneID 	= 5007;

//	Presents the get passphrase dialog to the user until the user aborts or
//	enters a passphrase of the correct format. If the user chooses to set a
//	new passphrase, *changePassphrase is TRUE

	static OSStatus
DoCommonGetPassphraseDialog(
	ConstStr255Param 	prompt,
	Boolean				defaultReadOnly,
	Boolean				disableReadOnly,
	Boolean				hideReadOnly,
	StringPtr 			passphrase,
	Boolean				*mountReadOnly)
{
	CPGPStDialogHandler		dialogHandler( kGetPassphraseDialogResID, nil );
	CGetPassphraseDialog	*dialogObj;
	OSStatus				status;
	
	pgpAssertAddrValid( prompt, uchar );
	pgpAssertAddrValid( passphrase, uchar );
	pgpAssertAddrValid( mountReadOnly, Boolean );
	
	status = noErr;
	
	dialogObj = (CGetPassphraseDialog *) dialogHandler.GetDialog();
	if( IsNull( dialogObj ) )
	{
		pgpDebugMsg( "GetNewPassphraseForDisk: Nil dialog object" );
		return( memFullErr );
	}
	
	dialogObj->SetPrompt( prompt );
	dialogObj->SetReadOnlyStatus( defaultReadOnly, disableReadOnly,
					hideReadOnly );
	
	dialogObj->Show();
	
	while (TRUE)
	{
		MessageT	hitMessage = dialogHandler.DoDialog();

		if( hitMessage == msg_Cancel )
		{
			status = userCanceledErr;
			break;
		}
		else if( hitMessage == msg_OK )
		{
			dialogObj->GetPassphrase( passphrase );
			*mountReadOnly = dialogObj->GetReadOnlyStatus();
			
			break;
		}
	}

	dialogObj->Hide();
	
	return( status );
}

//	Presents the get passphrase dialog to the user until the user aborts or
//	enters a passphrase of the correct format.

	OSStatus
DoMountDiskPassphraseDialog(
	const FSSpec	*fileSpec,
	Boolean			forceReadOnly,
	StringPtr 		passphrase,
	Boolean			*mountReadOnly)
{
	Str255		prompt;
	OSStatus	status = noErr;
	Boolean		readOnly;
	
	AssertSpecIsValid( fileSpec, "DoMountDiskPassphraseDialog" );
	pgpAssertAddrValid( passphrase, uchar );
	pgpAssertAddrValid( mountReadOnly, Boolean );

	GetIndString( prompt, kDialogStringListResID,
			kGetPassphraseDialogPromptStrIndex );
	PrintPString( prompt, prompt, fileSpec->name );
	
	readOnly = forceReadOnly;
	if( ! readOnly )
	{
		PGPDiskFileInfo		fileInfo;
		
		status = GetPGPDiskFileInfo( fileSpec, &fileInfo );
		if( IsntErr( status ) )
		{
			readOnly = fileInfo.fileIsOnLockedVolume || fileInfo.fileIsLocked;
		}
	}
	
	if( IsntErr( status ) )
	{
		status = DoCommonGetPassphraseDialog( prompt, readOnly, readOnly,
						FALSE, passphrase, mountReadOnly );
	}
	
	return( status );
}

//	Presents the get passphrase dialog to the user until the user aborts or
//	enters a passphrase of the correct format.

	OSStatus
DoGetOldPassphraseDialog(
	ConstStr255Param 	diskName,
	StringPtr 			passphrase)
{
	Str255		prompt;
	OSStatus	status;
	Boolean		mountReadOnly;
	
	pgpAssertAddrValid( diskName, uchar );
	pgpAssertAddrValid( passphrase, uchar );

	GetIndString( prompt, kDialogStringListResID,
			kOldPassphraseDialogPromptStrIndex );
	PrintPString( prompt, prompt, diskName );
	
	status = DoCommonGetPassphraseDialog( prompt, FALSE, FALSE, TRUE,
					passphrase, &mountReadOnly );
	
	return( status );
}

//	Presents the remove passphrase dialog to the user until the user aborts or
//	enters a passphrase of the correct format.

	OSStatus
DoGetRemovePassphraseDialog(
	ConstStr255Param 	diskName,
	StringPtr 			passphrase)
{
	Str255		prompt;
	OSStatus	status;
	Boolean		mountReadOnly;
	
	pgpAssertAddrValid( diskName, uchar );
	pgpAssertAddrValid( passphrase, uchar );

	GetIndString( prompt, kDialogStringListResID,
			kRemovePassphraseDialogPromptStrIndex );
	PrintPString( prompt, prompt, diskName );
	
	status = DoCommonGetPassphraseDialog( prompt, FALSE, FALSE, TRUE,
					passphrase, &mountReadOnly );
	
	return( status );
}

//	Presents the get passphrase dialog to the user until the user aborts or
//	enters the master passphrase.

	OSStatus
DoGetMasterPassphraseDialog(
	ConstStr255Param 	diskName,
	StringPtr 			masterPassphrase)
{
	Str255		prompt;
	OSStatus	status;
	Boolean		mountReadOnly;
	
	pgpAssertAddrValid( diskName, uchar );
	pgpAssertAddrValid( masterPassphrase, uchar );

	GetIndString( prompt, kDialogStringListResID,
			kMasterPassphraseDialogPromptStrIndex );
	PrintPString( prompt, prompt, diskName );
	
	status = DoCommonGetPassphraseDialog( prompt, FALSE, FALSE, TRUE,
						masterPassphrase, &mountReadOnly );
	
	return( status );
}

CGetPassphraseDialog::CGetPassphraseDialog()
{
}

CGetPassphraseDialog::CGetPassphraseDialog(LStream *inStream)
	: CPassphraseDialog(inStream)
{
}

CGetPassphraseDialog::~CGetPassphraseDialog()
{
}

	Boolean
CGetPassphraseDialog::GetReadOnlyStatus(void)
{
	LCheckBox	*readOnlyCheckboxObj;
	
	readOnlyCheckboxObj = (LCheckBox *) FindPaneByID( kReadOnlyCheckboxPaneID );
	pgpAssertAddrValid( readOnlyCheckboxObj, VoidAlign);
	
	return( readOnlyCheckboxObj->GetValue() == kControlCheckBoxCheckedValue );
}

	void
CGetPassphraseDialog::SetReadOnlyStatus(
	Boolean	readOnly,
	Boolean	disableCheckbox,
	Boolean	hideCheckbox)
{
	LCheckBox	*readOnlyCheckboxObj;

#if BETA
	if ( BetaExpired() )
	{
		readOnly		= TRUE;
		disableCheckbox	= TRUE;
	}
#endif

	readOnlyCheckboxObj =
			(LCheckBox *) FindPaneByID( kReadOnlyCheckboxPaneID );
	pgpAssertAddrValid( readOnlyCheckboxObj, VoidAlign);
	
	readOnlyCheckboxObj->SetValue( readOnly ?
			kControlCheckBoxCheckedValue : 0 );
	
	if( hideCheckbox )
	{
		readOnlyCheckboxObj->Hide();
	}
	
	if( disableCheckbox )
	{
		readOnlyCheckboxObj->Disable();
	}
}
