/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: SHA.h,v 1.2.8.1 1998/11/12 03:05:47 heller Exp $
____________________________________________________________________________*/

#ifndef SHS_H
#define SHS_H


/* NIST proposed Secure Hash Standard.

   Written 2 September 1992, Peter C. Gutmann.
   This implementation placed in the public domain.

   Modified 1 June 1993, Colin Plumb.
   These modifications placed in the public domain.

   Comments to pgut1@cs.aukuni.ac.nz */

// The SHS block size and message digest sizes, in bytes

class SHA
{
public:

	enum { kSHS_BLOCKSIZE = 64 };
	enum { kSHS_DIGESTSIZE = 20 };
	
	typedef union Digest
		{
		uchar	bytes[ kSHS_DIGESTSIZE ];
		ulong	longs[ kSHS_DIGESTSIZE / sizeof( ulong ) ];
		} Digest;
	
				SHA(void);
	virtual		~SHA(void)	{ }

	virtual void	Init(void);
	virtual void	Update(const uchar *buf, short len);
	virtual void	Final(Digest *	digest);
	virtual SHA		*Clone();
protected:
	void	Transform(void);

	ulong	mData[16];				// SHS data buffer
	Digest	mDigest;
	ulong	mCountHi;		// 64-bit byte count
	ulong	mCountLo;		// 64-bit byte count
};

#endif	// SHS_H
