/*____________________________________________________________________________
	TranslatorUtils.h
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: TranslatorUtils.h,v 1.13.2.1.2.1 1998/11/12 03:06:53 heller Exp $
____________________________________________________________________________*/
#pragma once

#include "EudoraTypes.h"

#include "pgpTypes.h"

#include "CComboError.h"

#include "pgpEncode.h"
#include "PGPclientLib.h"

#ifdef __cplusplus
extern "C" {
#endif




/* we use this to see if we've already processed a message
when Eudora calls CanTranslate file */
const uchar	kPGPAlreadyProcessedParamName[]		= "\pPGPProcessed";
const uchar	kPGPAlreadyProcessedParamValue[]	= "\pyes";

			
			
long	SignatureDataToEudoraResult( PGPEventSignatureData const *sigData );


OSErr	ParseFileForMIMEType( const FSSpec *spec,
			emsMIMETypeHandle *typeHandlePtr );




OSErr	CopyFileToFileRef( PGPMemoryMgrRef	memoryMgr,
			const FSSpec * fileToCopy, short destFileRef );

					
					
#if PGP_DEBUG
	void	DebugCopyToRAMDisk( PGPMemoryMgrRef memoryMgr, const FSSpec *spec,
					ConstStr255Param name );
#else
	#define DebugCopyToRAMDisk( memoryMgr, spec, name )
#endif



OSErr	FSpReadFileIntoBuffer( const FSSpec * spec,
			void ** bufferOut, ulong *	 bufferSizeOut );


void			MyGetIndCString( ushort whichString, char *theString );
StringHandle	GetIndStringHandle( ushort whichString );


long			CComboErrorToEudoraError( CComboError &err );



OSErr	EliminateMIMEHeader( const FSSpec *spec );



CComboError	GetRecipientList( PGPContextRef context,
				PGPtlsContextRef tlsContext,
				const StringHandle ** addresses,
				PGPKeySetRef allKeys,
				Boolean isPGPMime,
				PGPKeySetRef * keySet,
				PGPRecipientSettings *	settings,
				PGPKeySetRef *	keyToAdd);




#ifdef __cplusplus
}
#endif