/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: pgpClientLib.h,v 1.42.2.3.2.1 1998/11/12 03:07:07 heller Exp $
____________________________________________________________________________*/

#ifndef Included_pgpClientLib_h	/* [ */
#define Included_pgpClientLib_h

#include "pgpPubTypes.h"

#include "pflPrefs.h"
#include "pgpGroups.h"
#include "pgpKeyServerPrefs.h"
#include "pgpUserInterface.h"
#include "pgpPassBuffer.h"
#include "pgpTLS.h"

PGP_BEGIN_C_DECLARATIONS

#if PRAGMA_IMPORT_SUPPORTED
#pragma import on
#endif

typedef enum PGPFileSelector
{
	kPGPFileSelector_PublicKeys	= 1,
	kPGPFileSelector_PrivateKeys,
	kPGPFileSelector_RandomSeed,
	kPGPFileSelector_Groups,
	kPGPFileSelector_KeyShares

} PGPFileSelector;

enum
{
	/* relevant signing and encryption */
	kPGPUISettingsTextOutput		= (1UL << 0 ),
	kPGPUISettingsNoMacBinary		= (1UL << 1),
	kPGPUISettingsSmartMacBinary	= (1UL << 2),
	kPGPUISettingsForceMacBinary	= (1UL << 3),
	
	/* encryption only */
	kPGPRecipientSettingsWipeOriginal		= (1UL << 8),
	kPGPRecipientSettingsConvEncrypt		= (1UL << 9),
	kPGPRecipientSettingsFYEO				= (1UL << 10),
	
	/* signing only */
	kPGPGetPassphraseSettingsDetachedSig	= (1UL << 16)
};

enum
{
	kPGPSelectKeysImportVariation	= (1L << 0),
	kPGPSelectKeysNoRSAKeys			= (1L << 1),

	kPGPSelectKeysDefault = 0
};

typedef PGPFlags	PGPUISettings;
typedef PGPFlags	PGPRecipientSettings;
typedef PGPFlags	PGPSelectKeysSettings;



/* PGPRecipientOptions */
typedef PGPFlags	PGPRecipientOptions;
enum
{
	kPGPRecipientOptionsHideFileOptions		= (1L << 0),
	kPGPRecipientOptionsAlwaysShowDialog	= (1L << 1),
	kPGPRecipientOptionsShowFYEO			= (1L << 2),

	kPGPRecipientOptionsDefault = 0
};

#define kPGPRecipientSettingsDefault		0
#define kPGPGetPassphraseSettingsDefault	0

enum
{
	kPGPGetPassphraseOptionsHideFileOptions	= (1L << 0),

	kPGPGetPassphraseOptionsDefault = 0
};

typedef PGPFlags	PGPGetPassphraseOptions;
typedef PGPFlags	PGPGetPassphraseSettings;

//	numDefaultRecipients containes the number of recipients already present
//	in the recipients list. Specify 0 for no default recipients.
//	defaultRecipients is the list of numDefaultRecipients recipients. Specify
//	nil for no default recipients.
//	dialogOptions contains programatic options for controlling dialog behavior.
//	defaultSettings contains the initial states of the dialog checkboxes.
//	userSettings contains the final states of the dialog checkboxes.
//	actualRecipients specifies the PGP encrypted
//  recipients chosen by the user. Use PGPFreeRecipientList() to delete the
//  recipient list. 

	PGPError
PGPClientRecipientDialog(
	PGPContextRef			context,					
	PGPtlsContextRef		tlsContext,
	PGPKeySetRef			allKeys,					
	PGPUInt32				numDefaultRecipients,		
	const PGPRecipientSpec	*defaultRecipients,			
	PGPRecipientOptions		dialogOptions,				
	PGPRecipientSettings	defaultSettings,
	PGPRecipientSettings	*userSettings,			
	PGPKeySetRef			*actualRecipients,			
	PGPKeySetRef			*newKeys);			
							 
			
/* caller must call PGPFreeKey() on actualSigningKey */
	PGPError
PGPClientSigningPassphraseDialog(
	PGPContextRef				context,				
	PGPKeySetRef				allKeys,				
	const char 					*prompt,				
	PGPGetPassphraseOptions		dialogOptions,			
	PGPGetPassphraseSettings	defaultSettings,		
	PGPKeyRef					defaultSigningKey,		
	char						passphrase[256],
	PGPGetPassphraseSettings	*userSettings,			
	PGPKeyRef 					*actualSigningKey);		

	PGPError
PGPClientDecryptionPassphraseDialog(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	const char			*prompt,						
	PGPKeySetRef		recipientKeys,
	const PGPKeyID		keyIDList[],		
	PGPUInt32			keyIDCount,
	PGPOptionListRef	additionalOptions,
	char				**passphrase,
	PGPKeyRef 			*decryptionKey,
	PGPKeySetRef		*newKeys);
	
	PGPError
PGPSelectKeysDialog(
	PGPContextRef			context,
	PGPSelectKeysSettings	settings,
	const char				*prompt,							
	PGPKeySetRef			fromSet,							
	PGPKeySetRef			validitySet,	/* can be NULL */
	PGPKeySetRef			*selectedSet);	/* Caller is responsible for	*/
											/* freeing selectedSet			*/

	PGPError
PGPGetKeyFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyRef			key,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGetKeyIDFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyID const *	keyID,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGetGroupFromServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPGroupSetRef		groupSet,
	PGPGroupID			groupID,
	const char			*domain,	/* if not-NULL, used for domain info */
	PGPUInt32			dialogDelayTicks,
	PGPKeySetRef		*resultSet);

	PGPError
PGPGroupListOperationOnServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeySetRef		allKeys,
	PGPBoolean			sendGroups,
	PGPGroupSetRef		*groupSet );

	PGPError
PGPSendKeyToServer(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	PGPKeyRef			key,
	PGPKeyServerEntry	*targetServer);	/* if NULL, follows domain */
	
	PGPError
PGPGuaranteeMinimumEntropy(
	PGPContextRef		context);

	PGPError
PGPReconstitutionDialog(
	PGPKeyRef			keyToCollect,
	PGPKeySetRef		keySet, 	/* used to find decryption key for key */
									/* share files and SKEP authentication */
	PGPtlsContextRef	tlsContext,	/* can be kInvalidPGPtlsContextRef */
	PGPByte **			passKey,	/* should be freed with PGPFreeData */
	PGPSize *			passKeySize);
	
	PGPError
PGPForYourEyesOnlyDialog(
	PGPContextRef	inContext,
	const char *	inString);

	PGPError
PGPConfirmRemoteKeyDialog(
	const char *			prompt,
	const char *			remoteHostName,
	PGPKeyRef				keyToConfirm,
	PGPtlsCipherSuiteNum	tlsCipher,
	PGPBoolean				askConfirm );

/*	If addedKeySetToJob is true, you will get another kPGPEvent_SignatureEvent
	for the signature. If you pass a keyset into defaultKeySet,
	PGPSignerKeyLookup will attempt to selectively import the new keys into
	your default key ring. If you pass a pointer to a keysetref into 
	newKeySet, PGPSignerKeyLookup will return the new keys.
*/
	PGPError
PGPSignerKeyLookup(
	PGPContextRef	context,
	PGPEvent *		event,				/*	the kPGPEvent_SignatureEvent */
	PGPKeySetRef	defaultKeySet,		/*	used for selective import validity
											(optional) */
	PGPBoolean *	addedKeySetToJob,	/* 	true if a keyset was added to the
											job */
	PGPKeySetRef *	newKeySet);			/*	signer key (optional) */
	
enum
{
	kPGPPrefDialog_ChangedKeyFiles 		= (1L << 0),
	kPGPPrefDialog_ChangedServerList	= (1L << 1)
};

typedef PGPFlags	PGPPrefDialogFlags;

PGPError	PGPPreferencesDialog(
					PGPContextRef 		context,
					PGPKeySetRef		allKeys,		/* Optional */
					PGPPrefRef 			clientPrefs,	/* Optional */
					PGPPrefRef 			adminPrefs,		/* Optional */
					PGPPrefDialogFlags 	*flags);		/* Optional */

typedef struct PGPClientDecodeEventHandlerData
{
	PGPContextRef			context;
	PGPtlsContextRef		tlsContext;
	PGPKeySetRef			allKeys;
	PGPKeyRef				decryptionKey;
	PGPBoolean				conventional;
	PGPBoolean				split;
	PGPPassBufferRef		passBuffer;
	PGPKeySetRef			newKeySet;
	PGPKeySetRef			recipientKeySet;
	PGPKeyID				*recipientKeyIDList;
	PGPUInt32				recipientKeyIDCount;
	char					prompt[256];
	PGPByte					*outputBuffer;
	PGPSize					outputBufferSize;
	PGPEventSignatureData	signatureData;
	PGPBoolean				signatureDataValid;
	PGPAnalyzeType			sectionType;
	
} PGPClientDecodeEventHandlerData;

PGPError	PGPInitClientDecodeEventHandlerData( PGPContextRef context,
					PGPtlsContextRef tlsContext, PGPKeySetRef allKeys,
					PGPClientDecodeEventHandlerData *data );
void		PGPCleanupClientDecodeEventHandlerData(
					PGPClientDecodeEventHandlerData *data );
PGPError	PGPClientDecodeEventHandler( PGPContextRef context,
					struct PGPEvent *event,
					PGPClientDecodeEventHandlerData *data );
					
OSStatus	PGPGetClientLibFSSpec(FSSpec *fileSpec);
PGPError	PGPGetPGPFileName(PGPContextRef context, PGPFileSelector whichFile,
						StringPtr fileName);
PGPError	PGPGetPGPFileDefaultFSSpec(PGPContextRef context,
						PGPFileSelector whichFile, FSSpec *fileSpec);
PGPError	PGPSetPGPFileFSSpec(PGPContextRef context,
						PGPFileSelector whichFile, const FSSpec *fileSpec );
PGPError	PGPSelectPGPFile(PGPContextRef context, PGPFileSelector whichFile,
						FSSpec *fileSpec);
						
	PGPError
PGPCheckAutoUpdateKeysFromServer(
	PGPMemoryMgrRef	memoryMgr,
	PGPBoolean		launchKeys,
	PGPBoolean *	updateAllKeys,				/* can be NULL */
	PGPBoolean *	updateTrustedIntroducers);	/* can be NULL */
	
	PGPError
PGPRSASupported(
	PGPBoolean *	hasRSA);
	
	PGPError
PGPIsAdminConfigured(
	PGPBoolean *	isConfigured);
		
#if PRAGMA_IMPORT_SUPPORTED
#pragma import reset
#endif

PGP_END_C_DECLARATIONS

/* Stack based class for saving and restoring thread storage */

#ifdef __cplusplus	/* [ */
class StPGPPreserveKeyServerStorage {
public:
			StPGPPreserveKeyServerStorage() : mStorage(NULL)
				{ PGPKeyServerCreateThreadStorage(&mStorage); }
			~StPGPPreserveKeyServerStorage()
				{ PGPKeyServerDisposeThreadStorage(mStorage); }

protected:
	PGPKeyServerThreadStorageRef	mStorage;
};
#endif	/* ] __cplusplus */

#endif /* ] Included_pgpClientLib_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
