/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CKeyserverTable.cp,v 1.8.8.1 1998/11/12 03:07:11 heller Exp $
____________________________________________________________________________*/

#include <Fonts.h>

#include <UGAColorRamp.h>
#include <UDrawingUtils.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>

#include "CKeyserverTable.h"
#include "pgpKeyServerPrefs.h"

#include "MacStrings.h"


const Int16 	kColumnWidth		= 349;
const Int16		kRowHeight			= 18;
const Int16 	kServerNameWidth	= 218;
const Int16		kDomainNameWidth	= 107;
const Int16		kLeftBorder			= 4;
const ResIDT	kValidKeyIconID		= 3014;
const ResIDT	kKeyAttrOffIconID	= 3015;
const ResIDT	kAnyDomainIconID	= 4763;
const ResIDT	kKeyServerIconID	= 4764;
const Int16		kLeftIndent			= 2;
const Int16		kIconWidth			= 16;
const Int16		kIconHeight			= 16;

CKeyserverTable::CKeyserverTable(
	LStream	*inStream)
		:	LTableView(inStream)
{
	mTableGeometry	= new LTableMonoGeometry(this,	kColumnWidth,
													kRowHeight);
	mTableSelector	= new LTableSingleSelector(this);
	mTableStorage	= new LTableArrayStorage(this,
		sizeof(PGPKeyServerEntry));
}

void
CKeyserverTable::FinishCreateSelf()
{
	InsertCols(1, 1, NULL, 0, TRUE);
}

CKeyserverTable::~CKeyserverTable()
{
}

	void
CKeyserverTable::DrawSelf()
{
	Rect frame;

	RGBForeColor(&UGAColorRamp::GetColor(colorRamp_Black));
	RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
	CalcLocalFrameRect(frame);
	EraseRect(&frame);
	LTableView::DrawSelf();
}

	void
CKeyserverTable::DrawCell(
	const STableCell	&inCell,
	const Rect			&inLocalRect)
{
	StDeviceLoop		devLoop(inLocalRect);		
	SInt16				depth;
	Uint32				dataSize = sizeof(PGPKeyServerEntry);
	PGPKeyServerEntry	entry;
	Str255				str;
	char				url[kMaxServerNameLength + 1];
	Rect				iconRect;

	while(devLoop.NextDepth(depth))
	{
		::RGBForeColor(&UGAColorRamp::GetColor(colorRamp_Black));
		::RGBBackColor(&UGAColorRamp::GetColor(colorRamp_White));
		::EraseRect(&inLocalRect);
		GetCellData(inCell, &entry, dataSize);
		
		iconRect.left 	= 	inLocalRect.left + kLeftIndent;
		iconRect.top	=	inLocalRect.top + 2;
		iconRect.right 	= 	iconRect.left + kIconWidth;
		iconRect.bottom = 	iconRect.top + kIconHeight;
		::PlotIconID(&iconRect, atNone, ttNone, kKeyServerIconID );
		
		PGPGetKeyServerURL( &entry, url );
		CToPString( url, str );
		::TextSize(9);
		::TextFont(kFontIDGeneva);
		if( IsKeyServerRoot( entry.flags ) )
			::TextFace( bold );
		else
			::TextFace(0);
		::TruncString(	kServerNameWidth - 28, str, truncMiddle);
		::MoveTo(inLocalRect.left + 22, inLocalRect.bottom - 5);
		::DrawString(str);
		::TextFace(0);
		
		if( entry.domain[0] )
		{
			::MoveTo(	inLocalRect.left + kServerNameWidth + 1,
						inLocalRect.bottom - 5);
			CToPString( entry.domain, str );
			::TruncString(	kDomainNameWidth - 4, str, truncMiddle);
			::DrawString(str);
		}
		else
		{
			iconRect.left	=	inLocalRect.left + kServerNameWidth +
								kLeftBorder;
			iconRect.top	=	inLocalRect.top + 2;
			iconRect.right 	= 	iconRect.left + kIconWidth;
			iconRect.bottom = 	iconRect.top + kIconHeight;
			::PlotIconID(&iconRect, atNone, ttNone, kAnyDomainIconID);
		}

		iconRect.left	=	inLocalRect.left + kServerNameWidth +
							kDomainNameWidth + kLeftBorder;
		iconRect.top	=	inLocalRect.top + 2;
		iconRect.right 	= 	iconRect.left + kIconWidth;
		iconRect.bottom = 	iconRect.top + kIconHeight;
		::PlotIconID(&iconRect, atNone, ttNone,
			IsKeyServerListed(entry.flags) ?
			kValidKeyIconID : kKeyAttrOffIconID );
	}
}

	void
CKeyserverTable::ClickCell(
	const STableCell&		inCell,
	const SMouseDownEvent&	inMouseDown)
{
	(void) inMouseDown;
	
	if(GetClickCount() == 2)
		BroadcastMessage(kKSTCellDoubleClickedMessageID,
							(void *)inCell.row);
}

	void
CKeyserverTable::SelectionChanged()
{
	BroadcastMessage(kKSTSelectionChangedMessageID, NULL);
}

