/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPSelectKeysDialog.h,v 1.4.8.1 1998/11/12 03:07:20 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPGPModalGrafPortView.h"
#include "pgpEncode.h"

class CSelectKeysTable;

class CSelectKeysDialog : public CPGPModalGrafPortView
{
public:

	enum				{ class_ID = 'ImpD' };
	
						CSelectKeysDialog(LStream * inStream);
	virtual				~CSelectKeysDialog();
	
	CComboError			Init(	PGPContextRef			inContext,
								PGPSelectKeysSettings	settings,
								PGPPrefRef				inClientPrefs,
								const char *			inPrompt,
								PGPKeySetRef			inFromSet,
								PGPKeySetRef			inValiditySet,
								PGPKeySetRef *			outSelectedSet);
	
	CComboError			GetKeys();
	virtual void		ListenToMessage(MessageT inMessage, void * ioParam);
		
protected:

	virtual void		FinishCreateSelf();
	
private:

	CSelectKeysTable	*mUserIDTable;
	
	void				AdjustButtons(void);
};


class CSelectKeysTable :	public LTableView,
							public LBroadcaster
{
public:
	enum 				{ class_ID = 'ImpT' };

						CSelectKeysTable(LStream * inStream);
	virtual				~CSelectKeysTable();
	
	CComboError			SetTableInfo(PGPContextRef	inContext,
								PGPPrefRef			inClientPrefs,
								PGPKeySetRef		inFromSet,
								PGPKeySetRef		inValiditySet,
								PGPBoolean			inShowRSA,
								PGPKeySetRef *		outSelectedSet);
								
	CComboError			GetKeys();

protected:

	PGPKeySetRef		mFromSet;
	PGPKeySetRef *		mSelectedSet;
	PGPKeyIterRef		mKeyIter;
	PixPatHandle		mBarberPixPat;
	PGPBoolean			mShowMarginalValidity;
	PGPBoolean			mMarginalIsInvalid;
	
	CComboError			AddKeysToTable(	PGPKeySetRef	inFromSet,
										PGPBoolean		inShowRSA );
	virtual void		HiliteCellActively(const STableCell & inCell,
								Boolean inHilite);
	virtual void		HiliteCellInactively(const STableCell & inCell,
								Boolean inHilite);
	
	virtual void		ClickSelf(const SMouseDownEvent & inMouseDown);
	
	virtual void		DrawSelf();
	virtual void		DrawCell(const STableCell & inCell,
								const Rect & inLocalRect);

	static PGPError		EventHandler(PGPContextRef context,
								PGPEvent * event, PGPUserValue userValue);	
};

