/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: PGPclientLibUtils.h,v 1.8.8.1 1998/11/12 03:07:27 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <Files.h>
#include <Memory.h>
#include <Quickdraw.h>

#include <LCommander.h>
#include <LView.h>

#include "pflPrefs.h"
#include "pgpBase.h"
#include "pgpPubTypes.h"
#include "pgpClientLib.h"
#include "CComboError.h"

typedef struct PGPclientLibState
{
	GrafPtr			savedPort;
	THz				savedZone;
	short			savedResFile;
	LView			*savedView;
	LCommander		*savedCommander;
	PGPBoolean		savedResLoad;
	
	PGPPrefRef		clientPrefsRef;
	PGPPrefRef		adminPrefsRef;

} PGPclientLibState;

PGP_BEGIN_C_DECLARATIONS

OSStatus	SetLibraryFSSpec(const FSSpec *fileSpec);

PGPError	EnterPGPclientLib(PGPContextRef context, PGPclientLibState *state);
void		ExitPGPclientLib(const PGPclientLibState *state);

PGP_END_C_DECLARATIONS

