/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: CPGPtoolsClipboardTask.h,v 1.13.8.1 1998/11/12 03:09:05 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPtoolsBufferTask.h"

class CPGPtoolsClipboardTask : public CPGPtoolsBufferTask
{
public:
						CPGPtoolsClipboardTask(PGPtoolsOperation operation);
	virtual				~CPGPtoolsClipboardTask(void);
							
	virtual	OSStatus	CalcProgressBytes(PGPContextRef context,
							ByteCount *bytes);
	virtual CToolsError	DecryptVerify(PGPContextRef	context,
								PGPtlsContextRef tlsContext,
								CDecodeParams *state);
	virtual	CToolsError	EncryptSign(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CEncodeParams *state);

protected:

	virtual	void		GetDecryptPassphrasePromptString(StringPtr prompt);
	virtual	void		GetTaskItemName(StringPtr name);
	virtual	CToolsError	ProcessOutputData(void);
	
private:

	OSErr			GetClipboardData(PGPContextRef context);
};