/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: CPGPtoolsTaskProgressDialog.cp,v 1.7.8.1 1998/11/12 03:09:17 heller Exp $
____________________________________________________________________________*/

#include "MacStrings.h"

#include "PGPtoolsResources.h"

#include "CPGPtoolsTaskProgressDialog.h"

CPGPtoolsTaskProgressDialog::CPGPtoolsTaskProgressDialog(LStream *inStream)
	: CGAProgressDialog(inStream)
{
	mTotalCompletedBytes 	= 0;
	mTaskCompletedBytes		= 0;
	mDialogHandler			= nil;
	mShowDelayStartTicks	= 0;
}

CPGPtoolsTaskProgressDialog::~CPGPtoolsTaskProgressDialog()
{
}

	void
CPGPtoolsTaskProgressDialog::SetProgressOperation(PGPtoolsOperation operation)
{
	ResID	windowTitleStrIndex = 0;
	ResID	formatStrIndex 		= 0;
	Str255	windowTitle;
	
	mProgressOperation = operation;
	
	switch( operation )
	{
		case kPGPtoolsEncryptOperation:
			windowTitleStrIndex = kEncryptStrIndex;
			formatStrIndex		= kEncryptingProgressFormatStrIndex;
			break;

		case kPGPtoolsSignOperation:
			windowTitleStrIndex = kSignStrIndex;
			formatStrIndex		= kSigningProgressFormatStrIndex;
			break;

		case kPGPtoolsEncryptSignOperation:
			windowTitleStrIndex = kEncryptSignStrIndex;
			formatStrIndex		= kEncryptingProgressFormatStrIndex;
			break;

		case kPGPtoolsDecryptVerifyOperation:
			windowTitleStrIndex = kDecryptVerifyStrIndex;
			formatStrIndex		= kDecryptingVerifyingProgressFormatStrIndex;
			break;

		case kPGPtoolsWipeOperation:
			windowTitleStrIndex = kWipeStrIndex;
			formatStrIndex		= kWipingProgressFormatStrIndex;
			break;

		default:
			pgpDebugMsg( "SetProgressOperation: Unknown operation" );
			break;
	}
	
	GetIndString( windowTitle, kPGPtoolsMiscStringsResID,
				windowTitleStrIndex );
	SetDescriptor( windowTitle );
	
	GetIndString( mItemNameFormatStr, kDialogStringsListResID,
				formatStrIndex );
}

	void
CPGPtoolsTaskProgressDialog::SetNewProgressItem(ConstStr255Param itemName)
{
	Str255	msg;

	PrintPString( msg, mItemNameFormatStr, itemName );
	SetCaption( msg );
	UpdatePort();
	
	mTotalCompletedBytes 	+= mTaskCompletedBytes;
	mTaskCompletedBytes		= 0;
}

	void
CPGPtoolsTaskProgressDialog::SetCompletedOperations(UInt32 completedOps)
{
	CGAProgressDialog::SetCompletedOperations( completedOps );
	
	if( ! IsVisible() )
	{
		Select();
		Show();
		UpdatePort();
	}
}
