/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: PGPtoolsPreferences.c,v 1.18.8.1 1998/11/12 03:09:32 heller Exp $
____________________________________________________________________________*/

#include "pgpMem.h"
#include "pgpKeys.h"
#include "pgpSDKPrefs.h"
#include "pgpClientPrefs.h"
#include "PGPOpenPrefs.h"

#include "PGPtoolsPreferences.h"

#define	kPreferencesPadSize		512L

typedef union PaddedPreferences
{
	PGPtoolsPreferences	prefs;
	uchar				padding[kPreferencesPadSize];

} PaddedPreferences;

PGPtoolsPreferences	gPreferences;

	static void
InitDefaultPreferences(PGPtoolsPreferences *prefs)
{
	pgpClearMemory( prefs, sizeof( prefs ) );

	prefs->version		= kPGPtoolsPreferencesVersion;
}

	PGPError
LoadPreferences(PGPContextRef context)
{
	PGPError	err;
	
	err = PGPsdkLoadDefaultPrefs( context );
	if( IsntPGPError( err ) )
	{
		PGPPrefRef		prefRef;
		
		err = PGPOpenClientPrefs( PGPGetContextMemoryMgr( context ), &prefRef );
		if( IsntPGPError( err ) )
		{
			PGPSize				prefsSize;
			PaddedPreferences	*paddedPrefs;
			
			pgpAssert( sizeof( PGPtoolsPreferences ) <=
					kPreferencesPadSize );

			prefsSize = sizeof( paddedPrefs );
			
			err = PGPGetPrefData( prefRef,
						kPGPPrefPGPtoolsMacPrivateData, &prefsSize,
						&paddedPrefs );
			if( IsntPGPError( err ) )
			{
				gPreferences = paddedPrefs->prefs;
				
				PGPDisposePrefData( prefRef, paddedPrefs );
			}
			
			(void) PGPClosePrefFile( prefRef );
		}
	}
	
	if( IsPGPError( err ) )
	{
		InitDefaultPreferences( &gPreferences );
		if( err == kPGPError_PrefNotFound )
			err = kPGPError_NoErr;
	}
	return( err );
}

	PGPError
SavePreferences(PGPContextRef context)
{
	PGPError		err;
	PGPPrefRef	prefRef;

	err = PGPOpenClientPrefs( PGPGetContextMemoryMgr( context ),
					&prefRef );
	if( IsntPGPError( err ) )
	{
		PaddedPreferences	paddedPrefs;
		
		pgpClearMemory( &paddedPrefs, sizeof( paddedPrefs ) );
		paddedPrefs.prefs = gPreferences;
		
		pgpAssert( sizeof( PGPtoolsPreferences ) <= kPreferencesPadSize );

		err = PGPSetPrefData( prefRef,
					kPGPPrefPGPtoolsMacPrivateData, sizeof( paddedPrefs ),
					&paddedPrefs );

		(void) PGPSavePrefFile( prefRef );
		(void) PGPClosePrefFile( prefRef );
	}
	
	return( err );
}





