/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: StSuspendAESpecialHandler.cp,v 1.2.20.1 1998/11/12 03:10:54 heller Exp $
____________________________________________________________________________*/

#include "StSuspendAESpecialHandler.h"



StSuspendAESpecialHandler::StSuspendAESpecialHandler(
	AEKeyword	inFunctionClass,
	Boolean		inIsSysHandler)
		: mFunctionClass(inFunctionClass), mHandler(nil),
		  mIsSysHandler(inIsSysHandler)
{
	Suspend();
}



StSuspendAESpecialHandler::~StSuspendAESpecialHandler()
{
	Resume();
}
	


	void
StSuspendAESpecialHandler::Suspend()
{
	::AEGetSpecialHandler(	mFunctionClass,
							&mHandler,
							mIsSysHandler);
	if (mHandler != nil) {
		::AERemoveSpecialHandler(	mFunctionClass,
									mHandler,
									mIsSysHandler);
	}
}



	void
StSuspendAESpecialHandler::Resume()
{
	if (mHandler != nil) {
		::AEInstallSpecialHandler(	mFunctionClass,
									mHandler,
									mIsSysHandler);
	}
}
