/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: MacProcesses.c,v 1.5.28.1 1998/11/12 03:19:44 heller Exp $
____________________________________________________________________________*/

#include "pgpMem.h"

#include "MacProcesses.h"

	Boolean
FindProcess(
	OSType 				type,				
	OSType 				creator,		
	ProcessSerialNumber *psn,				
	ProcessInfoRec		*processInfo,		
	FSSpec				*processSpec,		
	StringPtr			processName)		
{
	ProcessSerialNumber	tempPSN;
	ProcessInfoRec		tempProcessInfo;
	Str255				tempProcessName;
	FSSpec				tempProcessSpec;
	Boolean				foundProcess = FALSE;
	
	AssertAddrNullOrValid( psn, ProcessSerialNumber, "FindProcess" );
	AssertAddrNullOrValid( processInfo, ProcessInfoRec, "FindProcess" );
	AssertAddrNullOrValid( processSpec, FSSpec, "FindProcess" );
	AssertAddrNullOrValid( processName, uchar, "FindProcess" );
	
	if( IsNull( psn ) )
		psn = &tempPSN;
	
	if( IsNull( processInfo ) )
		processInfo = &tempProcessInfo;
		
	if( IsNull( processSpec ) )
		processSpec = &tempProcessSpec;
		
	if( IsNull( processName ) )
		processName = &tempProcessName[0];
	
	pgpClearMemory( processInfo, sizeof( *processInfo ) );
	
	psn->lowLongOfPSN 	= kNoProcess;
	psn->highLongOfPSN 	= 0;
	
	processInfo->processInfoLength	= sizeof( *processInfo );
	processInfo->processName		= processName;
	processInfo->processAppSpec		= processSpec;
	
	while( IsntErr( GetNextProcess( psn ) ) )
	{
		if( IsntErr( GetProcessInformation( psn, processInfo ) ) )
		{
			if( processInfo->processType == type &&
				processInfo->processSignature == creator )
			{
				foundProcess = TRUE;
				break;
			}
		}
	}

	return( foundProcess );
}
