/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: UInt64.h,v 1.10.18.1 1998/11/12 03:19:52 heller Exp $
____________________________________________________________________________*/

#pragma once


#include "pgpTypes.h"

class CUInt64
	{
	protected:
			void	InitLong( long num )
						{
						lo	= num;
						if ( num < 0 )
							hi = -1;
						else
							hi = 0;
						}
						
			void	InitULong( unsigned long num )
						{
						lo	= num;
						hi	= 0;
						}
	public:
	unsigned long	hi;
	unsigned long	lo;

	void			Init( unsigned long hiArg, unsigned long loArg )
						{
						hi	= hiArg;
						lo	= loArg;
						}
// constructors
	CUInt64( void )		{	}
	CUInt64( const UnsignedWide &num )
		{
		Init( num.hi, num.lo );
		}
	CUInt64( const wide &num )
		{
		Init( num.hi, num.lo );
		}
										
	CUInt64( unsigned long hiNum, unsigned long loNum)
		{ 
		hi	= hiNum;
		lo	= loNum;
		}
		
	CUInt64( unsigned long	num)		{	InitULong( num ); }
	CUInt64( unsigned char	num)		{	InitULong( (unsigned long)num ); }
	CUInt64( unsigned short	num)		{	InitULong( (unsigned long)num ); }
	CUInt64( unsigned int	num)		{	InitULong( (unsigned long)num ); }
	
	
	CUInt64( long theLong)		{	InitLong( (long)theLong ); }
	CUInt64( char	theChar)	{	InitLong( (long)theChar ); }
	CUInt64( short	theShort)	{	InitLong( (long)theShort ); }
	CUInt64( int		theInt)		{	InitLong( (long)theInt ); }

	operator	UnsignedWide( void ) const
					{
					return( *(const UnsignedWide *)this );
					}
					
	operator	wide( void ) const
					{
					return( *(const wide *)this );
					}
#if TYPE_LONGLONG
	operator	unsigned long long( void ) const
					{
					unsigned long long	temp;
					
					temp	= hi;
					temp	<<= 32;
					temp	|= lo;
					return( temp );
					}
#endif

#if PGP_DEBUG
	static void			sTest( void );
#endif
	};



inline CUInt64	operator ~( const CUInt64 &lhs )
					{
					return( CUInt64( ~lhs.hi, ~lhs.lo ) );
					}
					
CUInt64			operator +( const CUInt64 &lhs, const CUInt64 &rhs);

void			operator +=( CUInt64 &lhs, CUInt64 rhs);
					
CUInt64			operator -( const CUInt64 &lhs );
					
CUInt64			operator -( const CUInt64 &lhs, const CUInt64 &rhs);

					
					
inline int		operator ==( const CUInt64 &lhs, const CUInt64 &rhs)
					{
					return( lhs.lo == rhs.lo && lhs.hi == rhs.hi );
					}
					
inline int		operator !=( const CUInt64 &lhs, const CUInt64 &rhs)
					{
					return( lhs.lo != rhs.lo || lhs.hi != rhs.hi );
					}
					
					
int				operator <( const CUInt64 &lhs, const CUInt64 &rhs);
int				operator <=( const CUInt64 &lhs, const CUInt64 &rhs);

inline int		operator >( const CUInt64 &lhs, const CUInt64 &rhs )
					{ return( ! ( lhs <= rhs ) ); }
inline int		operator >=( const CUInt64 &lhs, const CUInt64 &rhs)
					{ return( ! ( lhs < rhs ) ); }

					
					
void			operator >>=( CUInt64 &lhs, const unsigned long rhs);
CUInt64			operator >>( const CUInt64 &lhs, const unsigned long count);

void			operator <<=( CUInt64 &lhs, const unsigned long rhs);
CUInt64			operator <<( const CUInt64 &lhs, const unsigned long count);
















