/*____________________________________________________________________________
	main.c
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: main.c,v 1.7.12.1 1998/11/12 03:20:22 heller Exp $
____________________________________________________________________________*/

#include "pgpConfig.h"	/* or pgpConfig.h in the CDK */

#if PGP_MACINTOSH	/* [ */


#include <CodeFragments.h>
#include <Gestalt.h>

#include "MacBasics.h"
#include "pgpDebug.h"
#include "pgpErrorsPriv.h"
#include "pgpMem.h"
#include "pgpUtilitiesPriv.h"

PGP_BEGIN_C_DECLARATIONS

pascal OSErr 	INIT_PGPsdk(CFragInitBlock *initBlock);
pascal void		TERM_PGPsdk(void);

pascal OSErr __initialize(const CFragInitBlock *theInitBlock);
pascal OSErr __terminate(void);

PGP_END_C_DECLARATIONS

/* Disable 68020 code generation for the 68020 check itself */
#if GENERATING68K
	#pragma code68020 off
#endif

	pascal OSErr
INIT_PGPsdk(CFragInitBlock *initBlock)
{
	long	gestaltResult;
	OSErr	err = noErr;
	
	/*
	** Check for a 68020 or later processor and bail immediately if
	** none is available.
	** It is assumed that all clients of this library are doing a
	** similar chack and refusing to run.
	*/
	
	if( Gestalt( gestaltProcessorType, &gestaltResult ) == noErr &&
		gestaltResult >= gestalt68020 )
	{
		err = __initialize( initBlock );

		if ( IsntErr( err ) )
			err	= PGPsdkInit();
		pgpAssert( IsntPGPError( err ) );
	}

	return( err );
}

	pascal void
TERM_PGPsdk(void)
{
	(void)pgpsdkCleanupForce();
	
	__terminate();
}

#if GENERATING68K
	#pragma code68020 reset
#endif


#elif PGP_WIN32



#if PGP_WIN32

#include <stdio.h>

#include <crtdbg.h>

_CRTIMP int __cdecl _CrtDbgReport(
		int,
		const char *,
		int,
		const char *,
		const char *,
		...)
{
	// Bogus function to prevent link errors
	printf( "_CrtDbgReport called\n" );
}

#else

#error unknown target

#endif


#endif








