/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPRandomDataGrafPort.cp,v 1.4.12.1 1998/11/12 03:20:42 heller Exp $
____________________________________________________________________________*/

#include <LPushButton.h>
#include <LProgressBar.h>
#include <LStaticText.h>
#include <PP_Messages.h>

#include "MacStrings.h"
#include "pgpDialogs.h"
#include "pgpErrors.h"
#include "pgpMem.h"
#include "pgpRandomPool.h"

#include "CPGPRandomDataGrafPort.h"


CPGPRandomDataGrafPortView::CPGPRandomDataGrafPortView(LStream *inStream)
	: CPGPUIGrafPortView(inStream)
{
	mProgressBar 		= NULL;
	mEntropyCollected	= 0;
	mLastMouseLoc.v		= 0;
	mLastMouseLoc.h		= 0;
}

CPGPRandomDataGrafPortView::~CPGPRandomDataGrafPortView()
{
}

	void
CPGPRandomDataGrafPortView::FinishCreateSelf()
{
	CPGPUIGrafPortView::FinishCreateSelf();
	
	mProgressBar = (LProgressBar *) FindPaneByID( kProgressBarPaneID );
	pgpAssertAddrValid( mProgressBar, VoidAlign );
	
	mOKButton->Hide();
}

	PGPError
CPGPRandomDataGrafPortView::SetOptions(
	PGPContextRef 					context,
	CPGPRandomDataDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPUIGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		mOptions = options;
		
		if( IsntNull( options->mPrompt ) )
		{
			Str255	pPrompt;
			
			CToPString( options->mPrompt, pPrompt );
			SetDescriptor( pPrompt );
		}
		
		mProgressBar->SetMaxValue( options->mNeededEntropyBits );
	}
	
	return( err );
}

	Boolean
CPGPRandomDataGrafPortView::HandleKeyPress(const EventRecord& inKeyEvent)
{
	Boolean		keyHandled;
	Char16		theChar = inKeyEvent.message & charCodeMask;
	
	keyHandled = CPGPUIGrafPortView::HandleKeyPress( inKeyEvent );
	
	mEntropyCollected += PGPGlobalRandomPoolAddKeystroke( theChar );
	if( mEntropyCollected >= mOptions->mNeededEntropyBits )
	{
		mEntropyCollected = mOptions->mNeededEntropyBits;
		SetDismissMessage( msg_OK );
	}		
	
	mProgressBar->SetValue( mEntropyCollected );

	return keyHandled;
}

	void
CPGPRandomDataGrafPortView::SetDescriptor(ConstStringPtr prompt)
{
	LStaticText	*captionObj;
	
	pgpAssertAddrValid( prompt, char );

	captionObj = (LStaticText *) FindPaneByID( kPromptTextPaneID );
	pgpAssertAddrValid( captionObj, VoidAlign );
	
	captionObj->SetDescriptor( prompt );
}

	void
CPGPRandomDataGrafPortView::DoIdle(const EventRecord &inMacEvent)
{
	GrafPtr		savePort;
	GrafPtr		wMgrPort;
	Point		mouseLoc;

	CPGPUIGrafPortView::DoIdle( inMacEvent );

	GetPort( &savePort );
	GetWMgrPort( &wMgrPort );	
	
	SetPort( wMgrPort );
	GetMouse( &mouseLoc );
	SetPort( savePort);
	
	if( mouseLoc.v != mLastMouseLoc.v ||
		mouseLoc.h != mLastMouseLoc.h )
	{
		mEntropyCollected +=
			PGPGlobalRandomPoolAddMouse( mouseLoc.h, mouseLoc.v );
		mLastMouseLoc = mouseLoc;

		if( mEntropyCollected >= mOptions->mNeededEntropyBits )
		{
			mEntropyCollected = mOptions->mNeededEntropyBits;
			SetDismissMessage( msg_OK );
		}		

		mProgressBar->SetValue( mEntropyCollected );
	}
}
