/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CInterruptLevelDRVRTester.cp,v 1.7 1999/03/10 02:34:05 heller Exp $
____________________________________________________________________________*/

#include <Timer.h>
#include <stddef.h>
#include "pgpMacMemory.h"
#include "MacFiles.h"
#include "MacDriverUtils.h"
#include "UInt64.h"

#include "SetupA5.h"


#if TARGET_RT_MAC_CFM
assumes 68K non-CFM
#endif

#include "CInterruptLevelDRVRTester.h"




CInterruptLevelDRVRTester::CInterruptLevelDRVRTester()
	: CInterruptLevelTester()
	{
	OSErr	err	= noErr;
	
	mTestInProgress		= false;
	mDriverRefNum		= 0;
	mDriveNumber		= 0;
	mAcknowledgeDone	= false;
	mCurBlock			= 0;
	mIODirection		= kNoDirection;
	
	RememberA5();
	}


CInterruptLevelDRVRTester::~CInterruptLevelDRVRTester( )
	{
	if ( mTestInProgress )
		{
		Stop();
		}
	}


/*___________________________________________________________________________
	What range of disk blocks (512 bytes) do we want to test for the file?
	
	We'll test just the range for the largest extent (which is the whole
	file if it is not fragmented).
___________________________________________________________________________*/
	OSErr
CInterruptLevelDRVRTester::GetTestBlockRange(
	short		fileRefNum,
	ulong *		firstBlockToTest,
	ulong *		numBlocksToTest)
	{
	OSErr			err	= fnfErr;
	DiskExtent *	extents;
	PGPUInt32		numExtents;
	
	*firstBlockToTest	= 0;
	*numBlocksToTest	= 0;
	
	err	= GetDiskExtentsForFork( fileRefNum, &extents, &numExtents );
	if ( IsntErr( err ) )
		{
		// we'll use just the largest extent
		DiskExtent	largestExtent	= extents[ 0 ];
		
		for( ulong index = 1; index < numExtents; ++index )
			{
			if ( extents[ index ].numBlocks > largestExtent.numBlocks )
				{
				largestExtent	= extents[ index ];
				}
			}
		
		FreeDiskExtentList( extents );
		extents	= nil;
		
		*firstBlockToTest	= largestExtent.diskBlockIndex;
		*numBlocksToTest	= largestExtent.numBlocks;
		}
	
	return( err );
	}
	
	
	
	OSErr
CInterruptLevelDRVRTester::Setup( short	fileRefNum )
	{
	OSErr	err	= noErr;
	
	err	= inherited::Setup( fileRefNum );
	if ( IsntErr( err ) )
		{
		err	= GetTestBlockRange( fileRefNum, &mFirstBlockToTest,
						&mNumBlocksToTest );
		if ( IsntErr( err ) )
			{
			mCurBlock	= mFirstBlockToTest;
			
			GetDriveNumberAndRefNumForVCB( GetVCBForFile( fileRefNum ),
						&mDriveNumber, &mDriverRefNum );
			}
		}
	
	return( err );
	}




	void
CInterruptLevelDRVRTester::HandleIOCompletion( MyPB *myPB )
	{
	ParamBlockRec *	pb	= &myPB->pb;
	
	mCurBlock	+= pb->ioParam.ioActCount / kDiskBlockSize;
	ulong		lastLegitimateBlock	= mFirstBlockToTest +
						(mNumBlocksToTest - 1);
	if ( mCurBlock > lastLegitimateBlock )
		mCurBlock	= mFirstBlockToTest;
	
	inherited::HandleIOCompletion( myPB );
	}
	
	
	
	
	void
CInterruptLevelDRVRTester::GetNextIOInfo(
	ulong *	startBlockPtr,
	ulong *	numBlocksPtr)
	{
	ulong		startBlock;
	ulong		endBlock;
	ulong		lastReadableBlock;
	const ulong	kMaxBufferBlocks	= sizeof( mBuffer ) / kDiskBlockSize;
	
	startBlock			= mCurBlock;
	endBlock			= startBlock + (kMaxBufferBlocks - 1);
	lastReadableBlock	= mFirstBlockToTest + (mNumBlocksToTest - 1);
	if ( endBlock > lastReadableBlock )
		{
		endBlock	= lastReadableBlock;
		}
	
	pgpAssert( startBlock <= endBlock );
	
	*startBlockPtr	= startBlock;
	*numBlocksPtr	= ( endBlock - startBlock ) + 1;
	}
	
	
	void
CInterruptLevelDRVRTester::DoIOFromTimeMgrTask()
	{
	ParamBlockRec *	pb;
	OSErr			err	= noErr;
	ulong			numBlocksToRead;
	
	mPB.thisObject	= this;
	pb	= &mPB.pb;
	
	pgpAssert( mDriveNumber > 0 );
	pgpAssert( mDriverRefNum >= mFirstBlockToTest  );
	pgpAssert( mCurBlock != 0 );

	GetNextIOInfo( &mCurBlock, &numBlocksToRead );


	pgpAssert( numBlocksToRead != 0 );
	pgpAssert( numBlocksToRead * kDiskBlockSize <= sizeof( mBuffer ) );
	pgpAssert( mCurBlock + numBlocksToRead <=
					mFirstBlockToTest + mNumBlocksToTest );


	MacDebug_FillWithGarbage( pb, sizeof( *pb ) );
	pb->ioParam.ioCompletion	= sIOCompletion;
	pb->ioParam.ioVRefNum		= mDriveNumber;
	pb->ioParam.ioRefNum		= mDriverRefNum;
	pb->ioParam.ioBuffer		= mBuffer;
	pb->ioParam.ioReqCount		= numBlocksToRead * kDiskBlockSize;
	pb->ioParam.ioPosMode		= fsFromStart;
	
	if ( NeedWidePositioning( mCurBlock, numBlocksToRead) )
		{
		pb->ioParam.ioPosMode	|= kWidePosOffsetMask;
		mPB.xpb.ioWPosOffset	= CUInt64( 0UL, mCurBlock ) << 9;
		}
	else
		{
		pb->ioParam.ioPosOffset		= mCurBlock * kDiskBlockSize;
		}
		
		
	if ( mIODirection == kReadDirection )
		{
		err	= PBReadAsync( pb );
		}
	else
		{
		err	= PBWriteAsync( pb );
		}
	AssertNoErr( err, "CInterruptLevelDRVRTester::DoIOFromTimeMgrTask" );
	}
	
	


