/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CFileDrop.cp,v 1.4 1999/03/10 02:33:15 heller Exp $
____________________________________________________________________________*/
#include <UDrawingState.h>
#include <Threads.h>

#include "CFileDrop.h"
#include "CXferWindow.h"
#include "PGPFoneUtils.h"

CFileDrop *CFileDrop::CreateFileDropStream(LStream *inStream)
{
	return (new CFileDrop(inStream));
}

CFileDrop::CFileDrop(LStream *inStream)
		:	LView(inStream),
			LDragAndDrop(UQDGlobals::GetCurrentPort(), this)
{
}

CFileDrop::~CFileDrop()
{
}

void
CFileDrop::FocusDropArea()
{
	OutOfFocus(nil);
	FocusDraw();
}

void
CFileDrop::HiliteDropArea(
	DragReference	inDragRef)
{
	Rect dropRect;
	RgnHandle dropRgn;
	
	ApplyForeAndBackColors();
	mPane->CalcLocalFrameRect(dropRect);
	::InsetRect(&dropRect, 1, 1);
	dropRgn = ::NewRgn();
	::RectRgn(dropRgn, &dropRect);
	::ShowDragHilite(inDragRef, dropRgn, true);
	::DisposeRgn(dropRgn);
}

Boolean
CFileDrop::ItemIsAcceptable(DragReference inDragRef, ItemReference inItemRef)
//
//	ItemIsAcceptable will be called whenever the Drag Manager wants to know if
//	the item the user is currently dragging contains any information that we
//	can accept.
//
//	In our case, the only thing we'll accept are flavorTypeHFS items.
//
{
	FlavorFlags		theFlags;
	return (GetFlavorFlags(inDragRef, inItemRef, flavorTypeHFS, &theFlags)
				== noErr);
}

void
CFileDrop::EnterDropArea(DragReference inDragRef, Boolean inDragHasLeftSender)
{
	// Let LDragAndDrop do its thing (hilight the area)
	LDragAndDrop::EnterDropArea(inDragRef, inDragHasLeftSender);
}

void
CFileDrop::LeaveDropArea(DragReference inDragRef)
{
	// Let LDragAndDrop do its thing (removes the hilighting)
	LDragAndDrop::LeaveDropArea (inDragRef);
	
}

void
CFileDrop::InsideDropArea(DragReference /*inDragRef*/)
{
	// The mouse location is where the mouse actually is on the screen. The
	// alternative is the pinned location, which is _usually_ the same location,
	// but can be different if the cursor is being constrained by a tracking handler.
	// This is useful when you want an area within a view to be 'off-limits' to
	// the ongoing drag.
	//
	// If we did want to do something based on where the cursor currently is in
	// our area (such as indicating an insertion point or something), it would
	// usually be best to use the pinned location for that work.
	//
	// Both mouse locations are returned in global screen coordinates
	//
	/*Point	theMouseLocation;
	Point	thePinnedLocation;
	::GetDragMouse(inDragRef, &theMouseLocation, &thePinnedLocation);*/
	::YieldToAnyThread();
}

void
CFileDrop::ReceiveDragItem(
	DragReference	inDragRef,
	DragAttributes	/*inDragAttrs*/,
	ItemReference	inItemRef,
	Rect			&/*inItemBounds*/)	// In Local coordinates
{
	Size theDataSize;
	HFSFlavor theFlavorData;
	
	::GetFlavorDataSize(inDragRef, inItemRef, flavorTypeHFS, &theDataSize);
	if(theDataSize && (theDataSize <= sizeof(HFSFlavor)))
	{
		::GetFlavorData(inDragRef, inItemRef, flavorTypeHFS, &theFlavorData, &theDataSize, 0L);
		((CXferWindow *)GetSuperView())->AddSend(&theFlavorData);
	}
}

