/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFPrefDialog.cp,v 1.6.10.1 1999/07/09 22:42:35 heller Exp $
____________________________________________________________________________*/
#include <UModalDialogs.h>
#include <UReanimator.h>
#include <UEnvironment.h>
#include <LPushButton.h>
#include <LStaticText.h>
#include <LCheckBox.h>
#include <LRadioButton.h>
#include <LMultiPanelView.h>
#include <LEditText.h>
#include <string.h>
#include "CPFPrefDialog.h"

#include "PGPFMacUtils.h"
#include "PGPFoneApplication.h"
#include "CPFWindow.h"
#include "CControlThread.h"
#include "CPopupList.h"
#include "CPFTSerial.h"
#include "CEncryptionStream.h"

const PaneIDT	kPrefPanelsView				= 'pMPV';
const ResIDT	kPhonePanelViewResID		= 132;
const ResIDT	kModemPanelViewResID		= 131;
const ResIDT	kEncryptionPanelViewResID	= 133;
const ResIDT	kXferPanelViewResID			= 135;

enum	
{
	kPhonePanelViewIndex		= 1,
	kModemPanelViewIndex		= 2,
	kEncryptionPanelViewIndex	= 3,
	kXferPanelViewIndex			= 4
};


#define NUMBAUDRATES	4
static char baudRates[NUMBAUDRATES][16] = {
	"57600",
	"38400",
	"19200",
	"9600"
	};

CPFPrefDialog *CPFPrefDialog::sPrefDialog=NIL;

CPFPrefDialog::CPFPrefDialog()
{
}

CPFPrefDialog::CPFPrefDialog(LStream *inStream)
	: LGADialog(inStream)
{
	sPrefDialog = this;
}

CPFPrefDialog::~CPFPrefDialog()
{
	DoPrefs(1);
	sPrefDialog = NIL;
}

void
CPFPrefDialog::FinishCreateSelf()
{
	UInt16	numPanels;
	
	LGADialog::FinishCreateSelf();
	mMultiView = (LMultiPanelView *) FindPaneByID(kPrefPanelsView);
	pgpAssertAddrValid( mMultiView, VoidAlign );
	mMultiView->AddPanel( kPhonePanelViewResID, NULL, kPhonePanelViewIndex );
	mMultiView->AddPanel( kModemPanelViewResID, NULL, kModemPanelViewIndex );
	mMultiView->AddPanel( kEncryptionPanelViewResID, NULL,
		kEncryptionPanelViewIndex );
	mMultiView->AddPanel( kXferPanelViewResID, NULL, kXferPanelViewIndex );
	
	// Force creation of all panels so we can control the LCommander hierarchy
	
	numPanels = mMultiView->GetPanelCount();
	for( UInt16 panelIndex = 1; panelIndex <= numPanels; panelIndex++ )
	{
		LView *	panel;
		
		LCommander::SetDefaultCommander( mMultiView );
		LPane::SetDefaultView( mMultiView );
		
		panel = mMultiView->CreatePanel( panelIndex );
	}
}

	void
CPFPrefDialog::InitPrefs(
	CPFWindow	*		pfWindow )
{
	mPFWindow	= pfWindow;
	
	LoadPanel( kPhonePanelViewIndex );
	LoadPanel( kModemPanelViewIndex );
	LoadPanel( kEncryptionPanelViewIndex );
	LoadPanel( kXferPanelViewIndex );
	mMultiView->SwitchToPanel( kPhonePanelViewIndex, FALSE );
}

	void
CPFPrefDialog::ListenToMessage(MessageT inMessage, void *ioParam)
{
	Cell theCell={0,0};
	
	(void) ioParam;
	
	switch(inMessage)
	{
		case 'okay':	/* OK */
			HideSelf();
			//get rest of info
			SavePanel( kPhonePanelViewIndex );
			SavePanel( kModemPanelViewIndex );
			SavePanel( kEncryptionPanelViewIndex );
			SavePanel( kXferPanelViewIndex );
		case 'canc':	/* cancel */
			if((mPFWindow->GetState() != _cs_connected) &&
					(mPFWindow->GetState() != _cs_connecting) &&
					(mPFWindow->GetState() != _cs_disconnecting) &&
					(mPFWindow->GetState() != _cs_initializing))
				mPFWindow->GetControlThread()->ResetTransport();
			delete this;
			break;
		case 'bSTF':{
			SFTypeList sfTypes;
			StandardFileReply reply;
			FInfo fndrInfo;
			
			sfTypes[0] = 'APPL';
			StandardGetFile(NIL, 1, sfTypes, &reply);
			if((reply.sfGood) && (!FSpGetFInfo(&reply.sfFile, &fndrInfo)))
			{
				gPGFOpts.fopt.textFileCreator = fndrInfo.fdCreator;
				pstrcpy(gPGFOpts.fopt.creatorAppName ,reply.sfFile.name);
				((LStaticText *)FindPaneByID('cTFC'))->SetDescriptor(gPGFOpts.fopt.creatorAppName);
			}
			break;}
		case 'bSRF':{
			uchar s[64];
			long d;
			
			if(GetSFDir(0, &d, NIL, s))
			{
				pstrcpy(gPGFOpts.fopt.volName, s);
				gPGFOpts.fopt.dirID = d;
				s[0]=0;
				pgp_GetFullPathname(pgp_GetVolRefNum(gPGFOpts.fopt.volName),
					gPGFOpts.fopt.dirID, s);
				((LStaticText *)FindPaneByID('cRCF'))->SetDescriptor(s);
			}
			break;}
	}
}

	void
CPFPrefDialog::LoadPanel(
	UInt16			panelIndex )
{
	LCheckBox	*	con;
	short			i,
					numCoders;
	Str255			s;
	LRadioButton *	radb;
	StringHandle	strh;
	LEditText	*	edit;
	CPopupList	*	cpopl,
				*	capopl;
	LPushButton	*	pushb;
	LStaticText	*	capt;
	CoderEntry	*	coders;
	
	switch( panelIndex )
	{
		case kPhonePanelViewIndex:
			(con=(LCheckBox *)FindPaneByID('xAlw'))->SetValue(gPGFOpts.popt.alwaysListen);
			(con=(LCheckBox *)FindPaneByID('xRin'))->SetValue(gPGFOpts.popt.playRing);
			if( IsFullDuplexMac() )
				(con=(LCheckBox *)FindPaneByID('xFul'))->SetValue(gPGFOpts.popt.fullDuplex);
			else
				(con=(LCheckBox *)FindPaneByID('xFul'))->Disable();
			
			coders = mPFWindow->GetControlThread()->mCoders;
			numCoders = mPFWindow->GetControlThread()->mNumCoders;
			cpopl = (CPopupList *)FindPaneByID('pCmp');
			capopl = (CPopupList *)FindPaneByID('p2Cm');
			for(i=0;i<numCoders;i++)
			{
				strcpy((char *)s, coders[i].name);
				c2pstr((char *)s);
				cpopl->AddItem(s);
				capopl->AddItem(s);
				if(gPGFOpts.popt.prefCoder == coders[i].code)
					cpopl->SetValue(i);
				if(gPGFOpts.popt.altCoder == coders[i].code)
					capopl->SetValue(i);
			}
			(radb=(LRadioButton *)FindPaneByID('rApp'))->SetValue(gPGFOpts.popt.connection == _cme_AppleTalk);
			if(UEnvironment::HasFeature(env_HasOpenTransport))
				radb->Enable();
			(radb=(LRadioButton *)FindPaneByID('rMod'))->SetValue(gPGFOpts.popt.connection == _cme_Serial);
			(radb=(LRadioButton *)FindPaneByID('rInt'))->SetValue(gPGFOpts.popt.connection == _cme_Internet);
			if(UEnvironment::HasFeature(env_HasOpenTransport) || UEnvironment::HasFeature(env_HasMacTCP))
				radb->Enable();
			strcpy((char *)s, gPGFOpts.popt.identity);
			c2pstr((char *)s);
			if(!s[0] && (strh = GetString(-16096)))
			{
				HLock((Handle)strh);
				BlockMove(*strh, s, 32);
				HUnlock((Handle)strh);
				ReleaseResource((Handle)strh);
			}
			(edit=(LEditText *)FindPaneByID('eNam'))->SetDescriptor(s);
			(con=(LCheckBox *)FindPaneByID('xInc'))->SetValue(gPGFOpts.popt.idIncoming);
			(con=(LCheckBox *)FindPaneByID('xOtg'))->SetValue(gPGFOpts.popt.idOutgoing);
			(con=(LCheckBox *)FindPaneByID('xSUn'))->SetValue(gPGFOpts.popt.idUnencrypted);
			break;
		case kModemPanelViewIndex:
			Point po = {53, 89};
			short numPorts = CPFTSerial::GetNumDevices();
			
			cpopl=(CPopupList *)FindPaneByID('pPrt');
			for(i=0;i<numPorts;i++)
			{
				pstrcpy(s, CPFTSerial::GetDeviceName(i));
				if(!pstrcmp(s, gPGFOpts.sopt.portName))
					cpopl->SetValue(i);
				cpopl->AddItem(s);
			}
			strcpy((char *)s,gPGFOpts.sopt.modemInit);
			c2pstr((char *)s);
			(edit=(LEditText *)FindPaneByID('eMIn'))->SetDescriptor(s);
			cpopl=(CPopupList *)FindPaneByID('pRat');
			for(i=0;i<NUMBAUDRATES;i++)
			{
				if(!strcmp(baudRates[i], gPGFOpts.sopt.baud))
					cpopl->SetValue(i);
				strcpy((char *)s, baudRates[i]);
				c2pstr((char *)s);
				cpopl->AddItem(s);
			}
			(con=(LCheckBox *)FindPaneByID('xHWo'))->SetValue((gPGFOpts.sopt.handshaking & 4) > 0);
			(con=(LCheckBox *)FindPaneByID('xHWi'))->SetValue((gPGFOpts.sopt.handshaking & 8) > 0);
			cpopl=(CPopupList *)FindPaneByID('pMax');
			cpopl->AddItem("\p9600");
			cpopl->AddItem("\p14400");
			cpopl->AddItem("\p28800");
			cpopl->SetValue(gPGFOpts.sopt.maxBaud);
			break;
		case kEncryptionPanelViewIndex:
			cpopl=(CPopupList *)FindPaneByID('pEnc');
			cpopl->AddItem("\pCAST");
			cpopl->AddItem("\pTripleDES");
			cpopl->AddItem("\pBlowfish");
			cpopl->AddItem("\pNone");
			cpopl->SetValue(gPGFOpts.popt.prefEncryptor);
			
			con=(LCheckBox *)FindPaneByID('xCAS');
			if(gPGFOpts.popt.cryptorMask & 1)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('xTDE');
			if(gPGFOpts.popt.cryptorMask & 2)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('xBlo');
			if(gPGFOpts.popt.cryptorMask & 4)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('xNon');
			if(gPGFOpts.popt.cryptorMask & 8)
				con->SetValue(1);
			
			con=(LCheckBox *)FindPaneByID('x768');
			if(gPGFOpts.popt.primeMask & 1)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('x102');
			if(gPGFOpts.popt.primeMask & 2)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('x153');
			if(gPGFOpts.popt.primeMask & 4)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('x204');
			if(gPGFOpts.popt.primeMask & 8)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('x307');
			if(gPGFOpts.popt.primeMask & 16)
				con->SetValue(1);
			con=(LCheckBox *)FindPaneByID('x409');
			if(gPGFOpts.popt.primeMask & 32)
				con->SetValue(1);
			cpopl=(CPopupList *)FindPaneByID('pDHP');
			cpopl->AddItem("\p768 bits");
			cpopl->AddItem("\p1024 bits");
			cpopl->AddItem("\p1536 bits");
			cpopl->AddItem("\p2048 bits");
			cpopl->AddItem("\p3072 bits");
			cpopl->AddItem("\p4096 bits");
			cpopl->SetValue(gPGFOpts.popt.prefPrime);
			break;
		case kXferPanelViewIndex:
			pushb=(LPushButton *)FindPaneByID('bSRF');
			if( pushb )
				pushb->AddListener(this);
			s[0]=0;
			pgp_GetFullPathname(pgp_GetVolRefNum(gPGFOpts.fopt.volName),
				gPGFOpts.fopt.dirID, s);
			(capt=(LStaticText *)FindPaneByID('cRCF'))->SetDescriptor(s);
			(pushb=(LPushButton *)FindPaneByID('bSTF'))->AddListener(this);
			capt=(LStaticText *)FindPaneByID('cTFC');
			capt->SetDescriptor(gPGFOpts.fopt.creatorAppName);
			break;
	}
}

	void
CPFPrefDialog::SavePanel(
	UInt16			panelIndex )
{
	Str255			s;
	CPopupList	*	cpopl,
				*	capopl;
	CoderEntry	*	coders;
	short			numCoders,
					i;

	switch( panelIndex )
	{
		case kPhonePanelViewIndex:
			if(((LRadioButton *)FindPaneByID('rApp'))->GetValue())
				gPGFOpts.popt.connection = _cme_AppleTalk;
			else if(((LRadioButton *)FindPaneByID('rMod'))->GetValue())
				gPGFOpts.popt.connection = _cme_Serial;
			else
				gPGFOpts.popt.connection = _cme_Internet;
			coders = mPFWindow->GetControlThread()->mCoders;
			numCoders = mPFWindow->GetControlThread()->mNumCoders;
			cpopl=(CPopupList *)FindPaneByID('pCmp');
			capopl=(CPopupList *)FindPaneByID('p2Cm');
			gPGFOpts.popt.prefCoder = coders[cpopl->GetValue()].code;
			gPGFOpts.popt.altCoder = coders[capopl->GetValue()].code;
			gPGFOpts.popt.alwaysListen = ((LCheckBox *)FindPaneByID('xAlw'))->GetValue();
			gPGFOpts.popt.playRing = ((LCheckBox *)FindPaneByID('xRin'))->GetValue();
			gPGFOpts.popt.fullDuplex = ((LCheckBox *)FindPaneByID('xFul'))->GetValue();
			((LEditText *)FindPaneByID('eNam'))->GetDescriptor(s);
			p2cstr(s);
			strcpy(gPGFOpts.popt.identity, (char *)s);
			gPGFOpts.popt.idIncoming = ((LControl *)FindPaneByID('xInc'))->GetValue();
			gPGFOpts.popt.idOutgoing = ((LControl *)FindPaneByID('xOtg'))->GetValue();
			gPGFOpts.popt.idUnencrypted = ((LControl *)FindPaneByID('xSUn'))->GetValue();
			break;
		case kModemPanelViewIndex:
			((LEditText *)FindPaneByID('eMIn'))->GetDescriptor(s);
			p2cstr(s);
			strcpy(gPGFOpts.sopt.modemInit, (char *)s);
			gPGFOpts.sopt.handshaking=0;
			if(((LCheckBox *)FindPaneByID('xHWo'))->GetValue())
				gPGFOpts.sopt.handshaking|=4;
			if(((LCheckBox *)FindPaneByID('xHWi'))->GetValue())
				gPGFOpts.sopt.handshaking|=8;
			cpopl = (CPopupList *)FindPaneByID('pRat');
			i=(cpopl=(CPopupList *)FindPaneByID('pRat'))->GetValue();
			cpopl->GetItem(i, s);
			p2cstr(s);
			if(strcmp((char *)s,gPGFOpts.sopt.baud))
				strcpy(gPGFOpts.sopt.baud,(char *)s);
			cpopl=(CPopupList *)FindPaneByID('pPrt');
			pstrcpy(gPGFOpts.sopt.portName, CPFTSerial::GetDeviceName(cpopl->GetValue()));
			gPGFOpts.sopt.maxBaud=((CPopupList *)FindPaneByID('pMax'))->GetValue();
			break;
		case kEncryptionPanelViewIndex:
			gPGFOpts.popt.prefEncryptor = ((CPopupList *)FindPaneByID('pEnc'))->GetValue();
			gPGFOpts.popt.cryptorMask = 0;
			gPGFOpts.popt.cryptorMask |= ((LCheckBox *)FindPaneByID('xCAS'))->GetValue();
			gPGFOpts.popt.cryptorMask |= ((LCheckBox *)FindPaneByID('xTDE'))->GetValue() << 1;
			gPGFOpts.popt.cryptorMask |= ((LCheckBox *)FindPaneByID('xBlo'))->GetValue() << 2;
			gPGFOpts.popt.cryptorMask |= ((LCheckBox *)FindPaneByID('xNon'))->GetValue() << 3;
			if(gPGFOpts.popt.prefEncryptor == _enc_cast)
				gPGFOpts.popt.cryptorMask |= (1<<_enc_cast);
			if(gPGFOpts.popt.prefEncryptor == _enc_blowfish)
				gPGFOpts.popt.cryptorMask |= (1<<_enc_blowfish);
			if(gPGFOpts.popt.prefEncryptor == _enc_tripleDES)
				gPGFOpts.popt.cryptorMask |= (1<<_enc_tripleDES);
			if(gPGFOpts.popt.prefEncryptor == _enc_none)
				gPGFOpts.popt.cryptorMask |= (1<<_enc_none);
			gPGFOpts.popt.primeMask = 0;
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x768'))->GetValue();
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x102'))->GetValue() << 1;
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x153'))->GetValue() << 2;
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x204'))->GetValue() << 3;
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x307'))->GetValue() << 4;
			gPGFOpts.popt.primeMask |= ((LCheckBox *)FindPaneByID('x409'))->GetValue() << 5;
			gPGFOpts.popt.prefPrime = ((CPopupList *)FindPaneByID('pDHP'))->GetValue();
			break;
		case kXferPanelViewIndex:
			break;
	}
}

