/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFTSerial.h,v 1.4 1999/03/10 02:36:21 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <CRMSerialDevices.h>
#include <LThread.h>

#include "CPFTransport.h"

#define MAXSERPORTS			16
#define CONNECTSTRINGLEN	64
#define MAXPENDINGWRITES	3
#define INCBUFSIZE			2048

typedef struct SerialPort
{
	uchar name[32], inName[32], outName[32];
	CRMIconHandle deviceIcon;
	short inUse;
} SerialPort;

class CPFWindow;

class CPFTSerial		:	public CPFTransport
{
public:
					CPFTSerial();
					CPFTSerial(SerialOptions *serOpt, CPFWindow *cpfWindow, short *result);
					~CPFTSerial();
	PGErr			Connect(ContactEntry *con, short *connectResult);
	PGErr			Disconnect();
	PGErr			Listen(Boolean answer);
	PGErr			Reset();
	PGErr			Flush();
	PGErr			WriteBlock(void *buffer, long *count, short channel);
	PGErr			WriteAsync(long count, short channel, AsyncTransport *async);
	long			Read(void *data, long max, short *channel);
	void			WaitAsync(AsyncTransport *asyncTrans);
	
	short			GetModemResult(long timeout);
	short			WaitForRing();
	static CRMIconHandle	GetDeviceIcon(short index);
	static uchar	*GetDeviceName(short index);
	static short	GetNumDevices()	{	return sNumSerialPorts;	}
	static void		FindDevices();
private:
	long						mIndex, mOutdex;
	uchar						mInc[INCBUFSIZE];
	
	char						*mSerBuf, mConnectString[CONNECTSTRINGLEN];
	short						mSPort, mInRef, mOutRef;
	SerialOptions				mSerOpts;
	SThreadParamBlk				mReadPB, mPB;	// ...ioPB
	long						mLastRingTime;	// Mac Ticks for last ring
	long						mOutputDevice;	// Signature of sound output component

	static IOCompletionUPP		sSerialCompProc;
	static short				sNumSerialPorts;
	static struct SerialPort	sSerialPorts[MAXSERPORTS];
};

