/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPacketWatch.h,v 1.5 1999/03/10 02:35:23 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LView.h>
#include <LPeriodical.h>

#define PWOUTQUEUEENTRIES	10
#define PWFREQUENCY			45	//update every 45 ticks

#include "PGPFone.h"

class CMessageQueue;
class CSoundOutput;
class LStaticText;

class CPacketWatch	:	public LView,
						public LPeriodical
{
public:
	enum { class_ID = 'Pwch' };
	static CPacketWatch *CreatePacketWatchStream(LStream *inStream);
						CPacketWatch();
						CPacketWatch(LStream *inStream);
						~CPacketWatch();
	void				SpendTime(const EventRecord &inMacEvent);
	void				FinishCreateSelf();
	
	void				InitCall();
	void				GotPacket(Boolean good);
	void				Underflow()					{	mOutputUnderflows++;	}
	void				EscapedByte()				{	mEscapedBytes++;	}
	void				SentPacket(void)			{	mSentPackets++;		}
	void				OverflowOut(ulong num)		{	mOutOverflowLost += num;	}
	void				SetHPPQueue(CMessageQueue *soundOutQueue)	{	mSoundOutQ=soundOutQueue;	}
	void				SetSoundOutput(CSoundOutput *soundOut)	{	mSoundOutput=soundOut;		}
	void				SetGSMTimes(long full, long lite, long fullDec, long liteDec);
	void				SetRTTime(ulong rttVal)		{	mRTTime = rttVal;	}
	void				SetBandwidth(long bw)		{	mBandwidth = bw;	}
	void				SetJitter(long jitter)		{	mJitter = jitter;	}
private:	
	LStaticText			*mPW1, *mPW2;
	ulong				mLastUpdate, mBadPackets, mGoodPackets, mSentPackets, mOutputUnderflows,
							mOutOverflowLost, mEscapedBytes, mRTTime, mJitter;
	CMessageQueue		*mSoundOutQ;
	CSoundOutput		*mSoundOutput;
	short				mOutQueueSizes[PWOUTQUEUEENTRIES], mMaxQueueSize, mEntryPos, mAvgHPP;
	long				mLastSampleTime, mGSMFullTime, mGSMLiteTime, mGSMFullDecTime, mGSMLiteDecTime,
						mBandwidth;
};

extern CPacketWatch *gPacketWatch;

