/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPopupSlider.cp,v 1.4 1999/03/10 02:39:13 heller Exp $
____________________________________________________________________________*/
#include <UEnvironment.h>
#include <LStream.h>
#include <Threads.h>

#include "CPopupSlider.h"

#include "PGPFoneUtils.h"
#include "PGPFMacUtils.h"
#include "OffscreenUtils.h"

const Int16 SLIDERHEIGHT = 64;
const Int16 SLIDERWIDTH = 18;
const Int16 SLIDERSLACK = 1;
const Int16 INTHUMBHEIGHT = 6;
const Int16 OUTTHUMBHEIGHT = 10;

CPopupSlider*
CPopupSlider::CreatePopupSliderStream(
	LStream	*inStream)
{
	return (new CPopupSlider(inStream));
}


CPopupSlider::CPopupSlider(
	LStream	*inStream)
		: LPane(inStream)
{
	inStream->ReadData(&mValueMessage, sizeof(MessageT));
	inStream->ReadData(&mBasePictID, sizeof(Int16));
	inStream->ReadData(&mMinValue, sizeof(Int16));
	inStream->ReadData(&mMaxValue, sizeof(Int16));
	SignalIf_((mMinValue < 0) || (mMaxValue > 512));
	mOffset = 0;
	GetValue();
	mIcon0 = ::GetCIcon(mBasePictID);
	mIcon1 = ::GetCIcon(mBasePictID+1);
	mIcon2 = ::GetCIcon(mBasePictID+2);
	mIcon3 = ::GetCIcon(mBasePictID+3);
}

CPopupSlider::~CPopupSlider()
{
	::DisposeCIcon(mIcon0);
	::DisposeCIcon(mIcon1);
	::DisposeCIcon(mIcon2);
	::DisposeCIcon(mIcon3);
}

void
CPopupSlider::DrawSelf()
{
	Rect frame, frame2;
	CIconHandle cicnHandle;
	
	if(FocusDraw())
	{
		CalcLocalFrameRect(frame);
		if(mValue == 0)
			cicnHandle = mIcon0;
		else if(mValue < 85)
			cicnHandle = mIcon1;
		else if(mValue < 220)
			cicnHandle = mIcon2;
		else
			cicnHandle = mIcon3;
 		frame2 = (*cicnHandle)->iconPMap.bounds;
		OffsetRect(&frame2, -frame2.left, -frame2.top);
		OffsetRect(&frame2, frame.left+1, frame.top+1);
		if(UEnvironment::HasFeature(env_SupportsColor))
			ApplyForeAndBackColors();
		::PlotCIcon(&frame2, cicnHandle);
		frame.right--;	frame.bottom--;
		::FrameRect(&frame);
		::RGBForeColor(&gGrayRamp[4]);
		::MoveTo(frame.left+2,frame.bottom);
		::LineTo(frame.right,frame.bottom);
		::LineTo(frame.right,frame.top+2);
		::RGBForeColor(&gGrayRamp[0]);
	}
}

void
CPopupSlider::SetValue(Int16 value)
{
	Int16 maxOffset;

	maxOffset = SLIDERHEIGHT-SLIDERSLACK*2-OUTTHUMBHEIGHT-4;
	mValue = value;
	mOffset = maxOffset - mValue / ((float)(mMaxValue - mMinValue) / (float)maxOffset);
	if(mOffset > mMaxValue)
		mOffset = mMaxValue;
	else if(mOffset < mMinValue)
		mOffset = mMinValue;
}

long
CPopupSlider::GetValue(void)
{
	Int16 maxOffset;
  	float tempvalue;
  	
	maxOffset = SLIDERHEIGHT-SLIDERSLACK*2-OUTTHUMBHEIGHT-4;
	tempvalue = ((float)(mMaxValue - mMinValue) / (float)maxOffset) * (maxOffset - mOffset);
	mValue = tempvalue + mMinValue;
   	return mValue;
}

void
CPopupSlider::DrawSlider(Rect sliderRect, short pixDepth, Boolean update)
{
	RGBColor rgbGrayBkgndColor = {0xdddd,0xdddd,0xdddd};
	RGBColor rgbGrayLShadowColor = {0xcccc, 0xcccc, 0xcccc};
	RGBColor rgbGrayShadowColor = {0xaaaa, 0xaaaa, 0xaaaa};
	Rect slideRect, thumbRect;

	if(pixDepth > 1)
	{
		::RGBBackColor(&rgbGrayBkgndColor);
		if(!update)
		{
			::EraseRect(&sliderRect);
			::ForeColor(whiteColor);
			::MoveTo(sliderRect.left, sliderRect.bottom-1);
			::LineTo(sliderRect.left, sliderRect.top);
			::LineTo(sliderRect.right-1, sliderRect.top);
			::ForeColor(blackColor);
		}
		else
			::EraseRect(&mOldThumb);
	}
	else
	{
		::BackColor(whiteColor);
		::EraseRect(&sliderRect);
	}
	
	slideRect = sliderRect;
	slideRect.top++;	slideRect.bottom--;
	::InsetRect(&slideRect, 4, 0);
	::FrameRoundRect(&slideRect, 6, 6);
	::InsetRect(&slideRect, 2, 2);
	if(pixDepth > 1)
	{
		::RGBForeColor(&rgbGrayShadowColor);
		::PaintRoundRect(&slideRect, 6, 6);
		::ForeColor(blackColor);
	}
	::FrameRoundRect(&slideRect, 6, 6);
	thumbRect.top = slideRect.top+SLIDERSLACK+mOffset;
	thumbRect.bottom = thumbRect.top + OUTTHUMBHEIGHT;
	thumbRect.left = sliderRect.left + 2;
	thumbRect.right = sliderRect.right - 2;
	::EraseRect(&thumbRect);
	::FrameRoundRect(&thumbRect, 4, 4);
	thumbRect.top = slideRect.top+SLIDERSLACK+2+mOffset;
	thumbRect.bottom = thumbRect.top + INTHUMBHEIGHT;
	thumbRect.left = sliderRect.left+1;
	thumbRect.right = sliderRect.right-1;
	if(pixDepth > 1)
	{
		::RGBForeColor(&rgbGrayLShadowColor);
		::PaintRoundRect(&thumbRect, 4, 4);
		::ForeColor(blackColor);
	}
	else
		::EraseRect(&thumbRect);
	::FrameRoundRect(&thumbRect, 4, 4);
	mOldThumb = thumbRect;
	::InsetRect(&mOldThumb, -1, -2);
}

void
CPopupSlider::ClickSelf(const SMouseDownEvent &inMouseDown)
{
	GrafPtr wmgrPort, savePort;
	CGrafPort port;
	Point curMouse, urPos, oldMouse;
	Rect spRect, ispRect, frame, frame2, mbRect;
	short pixDepth, toff, maxOffset;
	long size, rowBytes;
	GDHandle maxDevice, dev;
	char *saveBits;
	OSErr result;
	CIconHandle cicnHandle;
	RgnHandle savedClip, grayRgn, savedGrayRgn, mBarRgn;
	
	if(FocusDraw() && ::StillDown())
	{
		CalcLocalFrameRect(frame);
		savedClip=NewRgn();
		GetClip(savedClip);
		::GetPort(&savePort);
		urPos.h=frame.right-2;
		urPos.v=frame.top;
		::LocalToGlobal(&urPos);
		curMouse = inMouseDown.whereLocal;
		::LocalToGlobal(&curMouse);
		if(UEnvironment::HasFeature(env_SupportsColor))
			GetCWMgrPort((CGrafPtr *)&wmgrPort);
		else
			GetWMgrPort(&wmgrPort);
		spRect.top = spRect.left=0;
		spRect.bottom = SLIDERHEIGHT + 5;
		spRect.right = SLIDERWIDTH + 3;
		SignalIf_((mOffset > mMaxValue) || (mOffset < mMinValue));
		::OffsetRect(&spRect, urPos.h, urPos.v);
		::OffsetRect(&spRect, 0, -mOffset + (curMouse.v - urPos.v) -
						(SLIDERSLACK + 4 + OUTTHUMBHEIGHT / 2));
		::SetPort(wmgrPort);
		grayRgn = ::GetGrayRgn();
		savedGrayRgn = ::NewRgn();
		::CopyRgn(grayRgn, savedGrayRgn);
		mBarRgn = ::NewRgn();
		mbRect = qd.screenBits.bounds;
		mbRect.bottom = mbRect.top + ::GetMBarHeight();
		::RectRgn(mBarRgn, &mbRect);
		::UnionRgn(savedGrayRgn, mBarRgn, savedGrayRgn);
		::DisposeRgn(mBarRgn);
		::SetClip(savedGrayRgn);
		ispRect = spRect;
		ispRect.right--;	ispRect.bottom--;
		maxDevice = GetMaxDevice(&spRect);
		if(!maxDevice)
			pixDepth = 1;
		else
			pixDepth = (*(*maxDevice)->gdPMap)->pixelSize;
		rowBytes = ((pixDepth*(spRect.right-spRect.left)+63)>>5)<<2;
		size=rowBytes*(long)(spRect.bottom-spRect.top);
		if((saveBits = (char *)pgp_malloc(size)) != NIL)
		{
			result = PGPCreateOffscrn(spRect, maxDevice, &port, &dev, saveBits, size);
			SignalIf_(result);
			PGPCopyToOffscrn((GrafPtr)&port, 0, 0, spRect, NIL);
			::SetPort(wmgrPort);
			::EraseRect(&ispRect);
			::FrameRect(&ispRect);
			::MoveTo(ispRect.left+2,ispRect.bottom);
			::LineTo(ispRect.right,ispRect.bottom);
			::LineTo(ispRect.right,ispRect.top+2);
			::InsetRect(&ispRect, 1, 1);
			DrawSlider(ispRect, pixDepth, false);
			maxOffset = ispRect.bottom - ispRect.top - 6 - SLIDERSLACK * 2 - OUTTHUMBHEIGHT;
			oldMouse = curMouse;
			while(::StillDown())
			{
				::GetMouse(&curMouse);
				if(curMouse.v != oldMouse.v)
				{
					toff = curMouse.v - (OUTTHUMBHEIGHT / 2) - (ispRect.top + 3 + SLIDERSLACK);
					if(toff < 0)
						toff = 0;
					else if(toff > maxOffset)
						toff = maxOffset;
					mOffset = toff;
					DrawSlider(ispRect, pixDepth, true);
					oldMouse = curMouse;
					GetValue();
					::SetPort(savePort);
					if(mValue == 0)
						cicnHandle = mIcon0;
					else if(mValue < 85)
						cicnHandle = mIcon1;
					else if(mValue < 220)
						cicnHandle = mIcon2;
					else
						cicnHandle = mIcon3;
			 		frame2 = (*cicnHandle)->iconPMap.bounds;
					OffsetRect(&frame2, -frame2.left, -frame2.top);
					OffsetRect(&frame2, frame.left+1, frame.top+1);
					if(UEnvironment::HasFeature(env_SupportsColor))
						ApplyForeAndBackColors();
					::PlotCIcon(&frame2, cicnHandle);
					::SetPort(wmgrPort);
					BroadcastMessage(mValueMessage, &mValue);
				}
				::YieldToAnyThread();
			}
			PGPCopyFromOffscrn((GrafPtr)&port, wmgrPort, 0, 0, spRect, srcCopy, NIL);
			PGPDisposeOffscrn(&port, dev);
			pgp_free(saveBits);
		}
		DisposeRgn(savedGrayRgn);
		SetClip(savedClip);
		DisposeRgn(savedClip);
		::SetPort(savePort);
	}
}

