/*____________________________________________________________________________
	pgpMem.h
	
	Copyright (C) 1996,1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	Memory allocation routines with debugging support

	$Id: pgpMem.h,v 1.3 1999/03/10 02:52:58 heller Exp $
____________________________________________________________________________*/

#ifndef Included_pgpMem_h	/* [ */
#define Included_pgpMem_h

#include <OpenTptModule.h>

#include "pgpTypes.h"
#include "pgpPFLErrors.h"
#include "pgpDebug.h"

#ifndef IsNull
#define IsntNull( p )	( (PGPBoolean) ( (p) != NULL ) )
#define IsNull( p )		( (PGPBoolean) ( (p) == NULL ) )
#endif


PGP_BEGIN_C_DECLARATIONS



#define pgpCopyMemory(src, dest, size)	\
			(OTMemcpy(dest, src, size))
			
#define pgpMemoryEqual(b1, b2, length)	\
			((PGPBoolean) OTMemcmp(b1, b2, length))

#define pgpFillMemory(buffer, length, fillChar)	\
			(OTMemset(buffer, fillChar, length))

#define pgpClearMemory(buffer, byteCount)						\
			(OTMemzero(buffer, byteCount))

/*void 	pgpCopyPattern(const void *pattern, size_t patternLength,
									void *buffer, size_t bufferLength);
*/
/* Lookie here!  An ANSI-compliant alignment finder! */
#ifndef 			alignof
#define 			alignof(type) (sizeof(struct{type _x; char _y;})		\
									- sizeof(type))
#endif

PGP_END_C_DECLARATIONS

#endif /* ] Included_pgpMem_h */

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
