/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PolicyManager.h,v 1.11 1999/02/21 12:32:23 wprice Exp $
____________________________________________________________________________*/

#pragma once

#include "PGPnetModuleCommon.h"
#include "IPHandler.h"

enum EPMStatus {
	pmStatus_PassThrough	=	1,
	pmStatus_ApplySA		=	2,
	pmStatus_DropPacket
};


EPMStatus	PMCheckPacketPolicy(			PGPUInt32				inAddress,
											PGPBoolean				inIncoming,
											const mblk_t *			inPacket,
											PGPBoolean				inAllowUnconfigured,
											PGPBoolean				inRequireSecure,
											SSAList *				inSAList,
											SHostEntryList *		inHostEntryList,
											SPendingSAList *		inPendingSAList );
EPMStatus	PMDoTransform(					queue_t *				inQ,
											PGPIPsecBuffer *		inBuffers,
											PGPUInt32				inAddress,
											PGPBoolean				inIncoming,
											PGPUInt32				inSPI,				
											SSAList *				inSAList,
											SHostEntryList *		inHostEntryList,
											mblk_t **				outPacketBlock );
PGPNetPrefHostEntry *	PMFindHost(			PGPUInt32				inAddress,
											SHostEntryList *		inHostEntryList );
EPMStatus				PMAcquireSA(		PGPUInt32				inAddress,
											PGPUInt32				ipAddrStart,
											PGPUInt32				ipMaskEnd,
											PGPBoolean				inIncoming,
											const mblk_t *			inPacket,
											SSAList *				inSAList,
											SPendingSAList *		inPendingSAList );
PGPikeSA *				PMFindSA(			PGPUInt32				inAddress,
											PGPUInt32				ipAddrStart,
											PGPBoolean				incoming,
											SSAList *				inSAList,
											SSAList **				outSAEntry );
PGPikeSA *				PMFindSAspi(		PGPUInt32				inAddress,
											PGPUInt32				spi,
											SSAList *				inSAList );
PGPBoolean				PMHasInSPI(			PGPikeSA *				inSA,
											PGPUInt32				spi );
PGPBoolean				PMCheckExpiration(	SSAList *				sal );
void					PMCheckRekey( 		SSAList *				sal );

