/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CLogPanel.h,v 1.7 1999/01/31 08:28:42 wprice Exp $
____________________________________________________________________________*/
#pragma once 

#include <LListener.h>
#include "CColumnTable.h"
#include "CPanel.h"
#include "PGPnetOpenPrefs.h"

class CLogTable;

class CLogPanel	:		public CPanel,
						public LListener
{
	friend				CLogTable;
public:
	enum { class_ID = 'pLog' };

						CLogPanel(LStream * inStream) : CPanel(inStream) { }
	virtual				~CLogPanel();
					
	virtual void		ListenToMessage(MessageT inMessage, void * ioParam);
	virtual void		Load(void * inParam);
	void				ClearLog();
	void				AddEvent( PGPnetLogEvent *	event );
protected:
	
	virtual void		FinishCreateSelf();

	PGPnetLogEvent *	mEvents;
	PGPSize				mNumEvents;
private:
	CLogTable *			mLogTable;
};

class	CLogTable	:	public CColumnTable
{
public:
	enum { class_ID = 'logT' };
						CLogTable(LStream *inStream) : CColumnTable(inStream) { };
	virtual				~CLogTable() { };
	void				FinishCreateSelf();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
	void				SetPanel( CLogPanel * panel ) { mPanel = panel;}
private:
	CLogPanel *			mPanel;
};

