/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPGPnet.h,v 1.20 1999/05/13 05:32:09 wprice Exp $
____________________________________________________________________________*/
#pragma once 


#include <LApplication.h>
#include <LPeriodical.h>
#include <LTextEditView.h>
#include "pflPrefs.h"
#include "pgpMemoryMgr.h"
#include "pgpUtilities.h"
#include "CPGPException.h"
#include "CPGPStDialogHandler.h"

class CPGPnetWindow;
class CLogPanel;
class CStatusPanel;
class CHostsPanel;
class LWindow;

const ResIDT	icon_InsecHost			=	1024;
const ResIDT	icon_SecHost			=	1025;
const ResIDT	icon_Gateway			=	1026;
const ResIDT	icon_InsecSubnet		=	1027;
const ResIDT	icon_SecSubnet			=	1028;
const ResIDT	icon_PGPKey				=	3032;
const ResIDT	icon_X509Cert			=	3033;
const ResIDT	icon_SharedSecret		=	3034;
const ResIDT	icon_GreenDot			=	3014;


class CPGPnet : public LApplication,
				public LPeriodical
{
public:
	static CPGPnet *		GetApplication() { return sApplication; }
	static void				ShowError(CPGPException & inErr);
	static PGPContextRef	GetPGPContext() { return sPGPContext; }
	static PGPKeySetRef		GetDefaultKeyrings() { return sDefaultKeyrings; }
	static PGPPrefRef		GetNetPrefs()	{ return sNetPrefs; }
	static PGPMemoryMgrRef	GetMemMgr()		{ return sMemoryMgr; }
	static PGPBoolean		HasPGPAuth()	{ return sHasPGPAuth; }
	static PGPBoolean		HasX509Auth()	{ return sHasX509Auth; }
	
							CPGPnet();
	virtual 				~CPGPnet();

	virtual Boolean			ObeyCommand(CommandT inCommand,
									void * ioParam);	
	virtual void			FindCommandStatus(CommandT inCommand,
									Boolean & outEnabled,
									Boolean & outUsesMark,
									Char16 & outMark,
									Str255 outName);
	virtual void			SpendTime( const EventRecord &inMacEvent );
	virtual void			EventHighLevel(
									const EventRecord&	inMacEvent);
	static void				PostPNEvent(
									UInt32			eventID,
									void *			data = NULL,
									PGPUInt32		dataLen = 0 );
	virtual void			SetLog( CLogPanel * panel ) { mLogPanel = panel; }
	virtual void			SetStatus( CStatusPanel * panel )
												{ mStatusPanel = panel; }
	virtual void			SetHosts( CHostsPanel * panel )
												{ mHostsPanel = panel; }
	virtual CStatusPanel *	GetStatus()			{ return mStatusPanel;	}
	virtual void			ShowAboutBox();
	void					CheckAuthKeys();
	PGPKeyRef				GetLocalPGPAuthKey();
	PGPKeyRef				GetLocalX509AuthKey( PGPSigRef *	pCert	);
#if PGP_DEBUG
	void					InstallDebugMenu(void);
	Boolean					AllowSubRemoval( LCommander*	inSub	);
#endif

protected:
	static CPGPnet *		sApplication;
	static PGPContextRef	sPGPContext;
	static PGPKeySetRef		sDefaultKeyrings;
	static PGPPrefRef		sNetPrefs;
	static PGPMemoryMgrRef	sMemoryMgr;
	static PGPBoolean		sHasPGPAuth,
							sHasX509Auth;
	
	virtual void			StartUp();

#if USE_MAC_DEBUG_LEAKS
	// we need to suspend leaks checking for the duration of these things
	// because PowerPlant will never release certain items
	virtual void		MakeMenuBar(void)
							{ MacLeaks_Suspend(); LApplication::MakeMenuBar();
							  MacLeaks_Resume(); }
	virtual void		MakeModelDirector(void)
							{ MacLeaks_Suspend(); LApplication::
									MakeModelDirector(); MacLeaks_Resume(); }
#endif // USE_MAC_DEBUG_LEAKS

private:
	CPGPnetWindow *		mWindow;
	CLogPanel *			mLogPanel;
	CStatusPanel *		mStatusPanel;
	CHostsPanel *		mHostsPanel;
	PGPBoolean			mFinished;
#if PGP_DEBUG
	LWindow *			mIKEWindow;
	LTextEditView *		mIKEView;
#endif
};

class CPGPnetStDialogHandler : public CPGPStDialogHandler
{
public:
						CPGPnetStDialogHandler(ResIDT inDialogResID, 
									LCommander *inSuper);
	virtual				~CPGPnetStDialogHandler(void);
	virtual void		EventHighLevel(
								const EventRecord&	inMacEvent);
};

