/*
	File:		MoreSetup.h

	Contains:	Sets up conditions etc for MoreIsBetter.

	Written by:	Pete Gontier (PCG)

	Copyright:	Copyright (C) 1998 by Apple Computer, Inc., all rights reserved.

				You may incorporate this Apple sample source code into your program(s) without
				restriction. This Apple sample source code has been provided "AS IS" and the
				responsibility for its operation is yours. You are not permitted to redistribute
				this Apple sample source code as "Apple sample source code" after having made
				changes. If you're going to re-distribute the source, we require that you make
				it clear in the source that the code was descended from Apple sample source
				code, but that you've made changes.

	Change History (most recent first):

         <3>     2/19/99    wprice  MODIFIED BY NETWORK ASSOCIATES
         <2>    10/11/98    Quinn   Convert "MorePrefix.h" to "MoreSetup.h".
         <1>    10/11/98    Quinn   Changed name from "MorePrefix.h" to "MoreSetup.h".
         <3>     5/11/98    Quinn   Use MoreAssertQ instead of MoreAssert.
         <2>     7/24/98    PCG	    rid of triplet #includes
         <2>     6/23/98    PCG     add copyright disclaimer stuff
         <1>     6/23/98    PCG     initial checkin
*/

#pragma once

#define OLDROUTINELOCATIONS		0
#define OLDROUTINENAMES			0
#define SystemSevenOrLater		1

#include <Errors.h>

#ifndef MORE_DEBUG
#	define MORE_DEBUG 1
#endif

#if MORE_DEBUG
#	define MoreAssert(x) \
		((x) ? true : (DebugStr ("\pMoreAssert failure: " #x), false))
#	define MoreAssertQ(x) \
		do { if (!(x)) DebugStr ("\pMoreAssertQ failure: " #x); } while (false)
#else
#	define MoreAssert(x) (true)
#	define MoreAssertQ(x)
#endif
